/*
 * Created on 2004/04/29
 *
 *
 *@Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.AbstractDataAccessObject;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;


/**
 * ^XNXPW[e[u𑀍삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DBTableTaskSchedule extends DBTableBase {
    /** ^XNXPW[e[u */
    public final static String TASK_SCHEDULEE_TABLE_NAME = "task_schedule";

    /** ^XNID J */
    public static final String TASK_ID = "task_id";

    /** ^XNJnJ */
    public static final String START_DATE = "start_date";

    /** ^XNIJ */
    public static final String END_DATE = "end_date";

    /* MO */
    private static Logger logger = null;

    /* tH[}bg */
    private DateFormat simpleDateformat =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * ^XNXPW[e[uVOgNX
     * CX^X𐶐܂B
     *
     */
    private DBTableTaskSchedule() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ^XNXPW[e[uVOgNXCX^X
     * Ԃ܂B
     *
     * @return ^XNXPW[e[uVOgNX
     * CX^X
     */
    public static DBTableTaskSchedule getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * ^XNXPW[e[u𐶐܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void createTable()
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        AbstractDataAccessObject dataaccessobject =
            DatabaseAccessControlKind.getInstance().getDataAccessObject();

        try {
            this.deleteTable(databaseAccess, TASK_SCHEDULEE_TABLE_NAME);
        } catch (SQLException e) {
            logger.info(
                DatabaseAccessControlKind.getInstance().getDatabaseName()
                + " : " + e.getMessage());
        }

        try {
            // A[e[ũV[PXe[u폜iPostgreSQLpj
            this.dropSequence(
                databaseAccess, dataaccessobject.getDropTaskSCheduleTable());

            // A[e[u
            databaseAccess.executeUpdate(
                dataaccessobject.getCreateTaskSCheduleTable());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * ^XNXPW[e[u폜܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void dropTable()
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            AbstractDataAccessObject dataaccessobject =
                DatabaseAccessControlKind.getInstance().getDataAccessObject();

            this.deleteTable(databaseAccess, TASK_SCHEDULEE_TABLE_NAME);
            this.dropSequence(
                databaseAccess,
                dataaccessobject.getDropTaskScheduleTableSequenceSQL());
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
            }
        }
    }

    /**
     * ^XNXPW[i[܂B
     *
     * @param taskID ^XNID
     * @param startDate ^XNJn
     * @param endDate ^XNI
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void put(
        final String taskID, final Date startDate, final Date endDate)
        throws DatabaseConnectionException, SQLException {
        DatabaseAccess databaseAccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            databaseAccess.executeUpdate(
                "insert into " + TASK_SCHEDULEE_TABLE_NAME + "( " + TASK_ID
                + ", " + START_DATE + ", " + END_DATE + " )" + " VALUES(" + "'"
                + taskID + "', " + "'" + simpleDateformat.format(startDate)
                + "'," + "'" + simpleDateformat.format(endDate) + "'" + ")");
        } finally {
            if (databaseAccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    databaseAccess);
                databaseAccess = null;
            }
        }
    }

    /**
     * w̃^XNID̃XPW[Ԃ܂B
     *
     * @param taskID ^XNID
     * @return ^XNXPW[
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized ArrayList findTarget(final String taskID)
        throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        // DatabaseAccess dataaccess = new DatabaseAccess();
        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        ArrayList list = null;

        try {
            //sql̍쐬
            String sql =
                "SELECT * from " + TASK_SCHEDULEE_TABLE_NAME + " where "
                + TASK_ID + "=" + "'" + taskID + "'";
            System.out.println(sql);

            // SQLXe[ggIuWFNg̍쐬
            // select̎s
            conn = dataaccess.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            list = new ArrayList();

            while (rs.next()) {
                TaskScheduleInfo taskInfo = new TaskScheduleInfo();

                if (rs.getObject(TASK_ID) != null) {
                    taskInfo.setTaskID((rs.getObject(TASK_ID).toString()));
                }

                if (rs.getObject(START_DATE) != null) {
                    taskInfo.setTaskStartDate((Date) rs.getObject(START_DATE));
                }

                if (rs.getObject(END_DATE) != null) {
                    taskInfo.setTaskEndDate((Date) rs.getObject(END_DATE));
                }

                list.add(taskInfo);
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }
        }

        return list;
    }

    /**
     * SẴ^XNXPW[XgƂĕԂ܂B
     *
     * @return list ^XNXPW[񃊃Xg
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized ArrayList findAll()
        throws SQLException, DatabaseConnectionException {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;

        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        ArrayList list = null;
        list = new ArrayList();

        try {
            String sql = "";

            //sql̍쐬
            sql = "SELECT * from "
                + DBTableTaskSchedule.TASK_SCHEDULEE_TABLE_NAME + " order by "
                + TASK_ID + " desc";

            // select̎s
            conn = dataaccess.getConnection();

            // SQLXe[ggIuWFNg̍쐬
            stmt = conn.createStatement();

            // select̎s
            rs = stmt.executeQuery(sql);

            while (rs.next()) {
                TaskScheduleInfo taskInfo = new TaskScheduleInfo();

                if (rs.getObject(TASK_ID) != null) {
                    taskInfo.setTaskID((rs.getObject(TASK_ID).toString()));
                }

                if (rs.getObject(START_DATE) != null) {
                    taskInfo.setTaskStartDate((Date) rs.getObject(START_DATE));
                }

                if (rs.getObject(END_DATE) != null) {
                    taskInfo.setTaskEndDate((Date) rs.getObject(END_DATE));
                }

                list.add(taskInfo);
            }
        } finally {
            if (rs != null) {
                try {
                    rs.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                rs = null;
            }

            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }

                stmt = null;
            }

            if (conn != null) {
                if (dataaccess != null) {
                    dataaccess.releaseConnection(conn);
                    conn = null;
                    DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                        dataaccess);
                }
            }

            dataaccess = null;
        }

        return list;
    }

    /**
     * w̃^XNID̃XPW[폜܂B
     *
     * @param taskID ^XNID
     * @throws DatabaseConnectionException f[^x[XRlNV
     * 擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public synchronized void deleteTaskSchedule(final String taskID)
        throws SQLException, DatabaseConnectionException {
        DatabaseAccess dataaccess =
            DatabaseAccessPool.getInstance().popQueueDatabaseAccess();

        try {
            //sql̍쐬
            String sql = "";

            sql = "delete from " + TASK_SCHEDULEE_TABLE_NAME + " where "
                + TASK_ID + "=" + "'" + taskID + "'";

            dataaccess.executeUpdate(sql);
        } finally {
            if (dataaccess != null) {
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(
                    dataaccess);
            }
        }
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DBTableTaskSchedule RESOURCE = new DBTableTaskSchedule();
    }
}
