/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model.apachederby;

import org.apache.derby.drda.NetworkServerControl;

import org.eclipse.jface.dialogs.MessageDialog;

import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Shell;

import org.eclipse.ui.PlatformUI;

import java.net.InetAddress;

import java.util.logging.Logger;


/**
 * Apache Derby lbg[NT[o𑀍삷郁\bh
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ApacheDerbyNetworkServer {
    /* Apache Derby NThread */
    private static Thread apacheDerbyServerThread;

    /* MO */
    private static Logger logger;

    /* Apache Derby NetworkServerControlCX^X */
    private NetworkServerControl apacheDerbyNetworkServer;

    /* Apache Derby NsbZ[W */
    private String abortMessage = "";

    /* Apache Derby NstO */
    private boolean isAbort;

    /*
     * Apache Derby lbg[NT[o𑀍삷郁\bh
     * VOgNXCX^X𐶐܂B
     */
    private ApacheDerbyNetworkServer() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Apache Derbylbg[NT[oJn܂B
     *
     * @throws Exception Apache Derbylbg[NT[oJnsꍇ
     */
    public void startDerbyNetworkServer() throws Exception {
        if (apacheDerbyNetworkServer != null) {
            throw new Exception("Already running Apache Derby Network Server");
        }

        isAbort = false;
        BusyIndicator.showWhile(
            PlatformUI.getWorkbench().getDisplay(),
            new Runnable() {
                public void run() {
                    try {
                        apacheDerbyNetworkServer =
                            new NetworkServerControl(
                                InetAddress.getByName("localhost"),
                                ApacheDerbyPreference.APACHE_DERBY_PORT);

                        apacheDerbyServerThread =
                            new Thread() {
                                    public void run() {
                                        try {
                                            apacheDerbyNetworkServer.start(
                                                null);
                                        } catch (Exception e) {
                                            isAbort = true;
                                            abortMessage =
                                                "Abort start Apache Derby server "
                                                + e.getMessage();
                                            logger.info(
                                                "Abort start Apache Derby server "
                                                + e.getMessage());
                                            e.printStackTrace();
                                        }
                                    }
                                };

                        /* Apache DerbyT[oX^[g */
                        try {
                            apacheDerbyServerThread.start();
                        } catch (Exception e) {
                            isAbort = true;
                            abortMessage =
                                "Abort start Apache Derby server "
                                + e.getMessage();
                            logger.info(
                                "Abort start Apache Derby server "
                                + e.getMessage());
                            e.printStackTrace();
                            throw e;
                        }
                    } catch (NoClassDefFoundError e) {
                        isAbort = true;
                        abortMessage =
                            "Abort start Apache Derby server. ClassNotFoundException "
                            + e.getMessage();
                        logger.info(
                            "Abort start Apache Derby server. ClassNotFoundException "
                            + e.getMessage());
                    } catch (Exception e) {
                        isAbort = true;
                        abortMessage =
                            "Abort start Apache Derby server " + e.getMessage();
                        logger.info(
                            "Abort start Apache Derby server " + e.getMessage());
                        e.printStackTrace();
                    }

                    if (!isAbort) {
                        /*
                         * Apache Derby Network ServerNAғmF܂Wait
                         */
                        isAbort = checkApacheDerby();
                    }
                }
            });

        if (isAbort) {
            throw new Exception(abortMessage);
        }
    }

    /*
     * Apache Derby Network ServerN܂Wait܂B
     *
     * @return isApacheAbort Apache Derby Network ServerNmFtO
     */
    private boolean checkApacheDerby() {
        /*
         * Apache Derby Network ServerN܂Wait loop
         */
        int count = 10;
        boolean isApacheAbort = false;

        while (true) {
            try {
                apacheDerbyNetworkServer.ping();

                break;
            } catch (Exception e) {
                logger.warning(
                    "Apache Derby NetworkServer ping " + e.getMessage());
            }

            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }

            count--;

            if (count < 0) {
                abortMessage = "Abort start Apache Derby server at ping";
                isApacheAbort = true;

                break;
            }
        }

        return isApacheAbort;
    }

    /**
     * Apache Derbylbg[NT[o~܂B
     *
     * @throws Exception Apache Derbylbg[NT[o̒~Ɏsꍇ
     */
    public void stopDerbyNetworkServer() throws Exception {
        try {
            if (apacheDerbyNetworkServer != null) {
                apacheDerbyNetworkServer.shutdown();
                logger.info("Apache Derby NetworkServer shutdown");
                apacheDerbyNetworkServer = null;
            }

            if (apacheDerbyServerThread != null) {
                apacheDerbyServerThread.interrupt();
                logger.info("Apache Derby Server Thread interrupt");
            }
        } catch (Exception e) {
            logger.warning("Abort Apache Derby server stop " + e.getMessage());
            throw e;
        }
    }

    /**
     * Apache Derbylbg[NT[oSysInfo擾܂B
     *
     * @throws Exception Apache Derbylbg[NT[oSysInfo擾
     * Ɏsꍇ
     */
    public void getSysInfoNetworkServer() throws Exception {
        try {
            if (apacheDerbyNetworkServer == null) {
                throw new Exception("Apache Derby inActive");
            }

            /*
                 * These methods return information about the Network
                 * Server running on the current machine on the
                 * default port number (1527).
                 */
            String myinfo = apacheDerbyNetworkServer.getSysinfo();

            /*
             * Use the runtimeinfo command or getRuntimeInfo method
             * to get memory usage and current session information
             * about the Network Server including user, database,
             * and prepared statement information.
             */
            String runTimeInfo = apacheDerbyNetworkServer.getRuntimeInfo();
            Shell shell = new Shell();
            MessageDialog.openInformation(
                shell, "Apache Derby sysinfo", myinfo);

            shell.dispose();

            /*
             * It returns a Properties object with the value of
             * all the NetServer properties as they are currently set.
             */
            /*
            Properties p = apacheDerbyServer.getCurrentProperties();
            p.list(System.out);
            System.out.println(p.getProperty("derby.drda.host"));
            */
        } catch (Exception e) {
            throw e;
        }
    }

    /*
     *  (non-Javadoc)
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();
        stopDerbyNetworkServer();
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ApacheDerbyNetworkServer getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * Apache Derby NThreadԂ܂B
     *
     * @return apacheDerbyServerThread Apache Derby NThread
     */
    public Thread getApacheDerbyServerThread() {
        return apacheDerbyServerThread;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final ApacheDerbyNetworkServer RESOURCE =
            new ApacheDerbyNetworkServer();
    }
}
