/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model.hsqldb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;

import org.eclipse.jface.action.IAction;
import org.hsqldb.Server;


/**
 * HSQLDBT[oXbh̊JnA~yHSQLDB}l[W
 * JnA~𐧌䂷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class HsqldbControl {
    /* HSQLDBT[oThread */
    private static Thread hsqldbServerThread;

    /* MO */
    private static Logger logger;

    /* GSQLDB}l[W */
    private HsqldbDatabaseManager manager;

    /*
     * HSQLDBCX^X𐶐܂B
     *
     */
    private HsqldbControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * HSQLDBT[oN܂B
     *
     * @throws HsqldbException HSQLDBT[oCX^X
     * ĂȂꍇ
     */
    public void startHsqlDB() throws HsqldbException {
        if (hsqldbServerThread != null) {
            logger.info("Already a HSQLDB server running");
            throw new HsqldbException("Already a HSQLDB server running");
        }

        /* HSQLDBT[o */
        hsqldbServerThread =
            new Thread() {
                    public void run() {
                        /* HSQLDBNp[^Zbg */
                        String[] args =
                            {
                                /*
                                 * the path and file name of the first database
                                 * file to use
                                */
                                "-database", HsqldbPreference.HSQLDB_DATA_NAME,


                                /* server alias for the first database file */
                                "-dbname", "",
                                /*
                                 * TCP/IP port used for talking to clients. All
                                 * databases are served on the same port.
                                 *
                                 */
                                "-port", HsqldbParams.getInstance().getPort(),


                                /* no System.exit() call when the database is
                                 * closed
                                 * (Vbg_ESystem.exit()
                                 * R[ׂǂ
                                 * tO)
                                 */
                                "-no_system_exit", "true"
                            };
                        Server.main(args);
                    }
                };

        /* HSQLDBT[oX^[g */
        hsqldbServerThread.start();
        logger.info("HSQLDB server start");
    }

    /**
     * HSQLDBT[o~܂B
     *
     * @throws ClassNotFoundException JDBChCoȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public void stopHsqlDB() throws ClassNotFoundException, SQLException {
        if (hsqldbServerThread == null) {
            return;
        }

        logger.info("HSQLDB server shutdown");

        Connection con = null;
        Statement stmt = null;

        try {
            // submits the SHUTDOWN statement
            Class.forName(HsqldbParams.getInstance().getDriver());

            String url = HsqldbParams.getInstance().getAccessUrl();
            con = DriverManager.getConnection(
                    url, HsqldbParams.getInstance().getUser(),
                    HsqldbParams.getInstance().getPasswd());

            String sql = HsqldbPreference.HSQLDB_SHUTDOWN_SQL;
            stmt = con.createStatement();
            stmt.executeUpdate(sql);
        } catch (ClassNotFoundException e) {
            logger.warning(
                "ERROR: failed to load HSQLDB JDBC driver. : " + e.getMessage());
            throw e;
        } catch (SQLException e) {
            logger.warning(e.getMessage());
            throw e;
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (con != null) {
                try {
                    con.close();
                } catch (SQLException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            hsqldbServerThread = null;
        }
    }

    /**
     * HSQLDB}l[WN܂B
     *
     * @param action IAction
     */
    public void startHsqlDBManager(IAction action) {
        if (manager != null) {
            return;
        }

        logger.info("HSQLDB manager start");
        manager = new HsqldbDatabaseManager();
        manager.run(action);
    }

    /**
     * HSQLDB}l[W~܂B
     *
     */
    public void stopHsqlDBManager() {
        if (manager == null) {
            return;
        }

        logger.info("HSQLDB manager shutdown");

        try {
            HsqldbDatabaseManager.createEmptyHsqlDatabase();
        } catch (ClassNotFoundException e) {
            logger.warning(
                "ERROR: failed to load HSQLDB JDBC driver. : " + e.getMessage());
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning("ERROR: failed to stop HSQLDB. : " + e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static HsqldbControl getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final HsqldbControl RESOURCE = new HsqldbControl();
    }
}
