/*
 * Created on 2004/04/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.alarm;

import java.text.MessageFormat;
import java.util.logging.Logger;

import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;


/**
 * XML͎̃G[Handler
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class DocumentParseErrorHandler extends DefaultHandler {
    /* MO */
    private static Logger logger;

    /* G[̃bZ[WtH[}bg
     * {0} :System ID
     * {1} :Line No.
     * {2} :Column No.
     * {3} :Error Message
     */
    private MessageFormat message = new MessageFormat("({0}: {1}, {2}): {3}");

    /**
     * G[bZ[WMO܂B<BR>
     *
     * @param x SAXParseException
     */
    private void print(final SAXParseException x) {
        String msg =
            message.format(
                new Object[] {
                    x.getSystemId(), new Integer(x.getLineNumber()),
                    new Integer(x.getColumnNumber()), x.getMessage()
                });
        logger = Logger.getLogger(this.getClass().getName());
        logger.warning(msg);
    }

    /**
     * vIG[̏s܂B<BR>
     *
     * @param x SAXParseException
     * @throws SAXParseException SAXp[XŏQꍇ
     */
    public void fatalError(final SAXParseException x) throws SAXParseException {
        print(x);
        throw x;
    }
}
