/*
 * Created on 2007/02/04
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.alarm.trap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;

import netjfwatcher.engine.preferance.AlarmFilterPreferencePage;
import netjfwatcher.engine.preferance.AlarmSnmpTrapPreferencePage;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmpagent.AgentTrapSendView;
import netjfwatcher.snmpagent.process.AgentDispatcher;
import netjfwatcher.snmpagent.process.AgentTrapPDU;

public class SenderAlarmTrap {

	/* ftHg̃R~jeB */
	private static final String DEFAULT_COMMUNITY = "public";

	/* MO */
	private static Logger logger;

	/* TrapMSNMPo[W */
	private int version;

	private SenderAlarmTrap() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public void checkAlarmTrap(String ipAddress, String message,
			String alarmLevel, String alarmCode) {
		String trapFlag = AlarmTrapResourceFileParse.getInstance()
				.getAlarmTrapFlag();
		if (trapFlag.equals(AlarmSnmpTrapPreferencePage.TRAP_FLAG_TRUE)) {
			String alarmLevelFilter = AlarmTrapResourceFileParse.getInstance()
					.getAlarmTrapLevel();
			if (checkAlarmLevelFilter(alarmLevel, alarmLevelFilter)) {
				sendTrap(message, alarmLevel, alarmCode);
			}
		}
	}

	private boolean checkAlarmLevelFilter(String alarmLevel, String alarmLevelFilter) {
		boolean isHit = false;

		if (alarmLevelFilter
				.equals(AlarmFilterPreferencePage.ALARM_LEVEL_INFO)) {
			isHit = true;
		} else if (alarmLevelFilter
				.equals(AlarmFilterPreferencePage.ALARM_LEVEL_WARNING)) {
			if (alarmLevel
					.equals(AlarmFilterPreferencePage.ALARM_LEVEL_WARNING)
					|| alarmLevel
							.equals(AlarmFilterPreferencePage.ALARM_LEVEL_ERROR)) {
				isHit = true;
			}
		} else if (alarmLevelFilter
				.equals(AlarmFilterPreferencePage.ALARM_LEVEL_ERROR)) {
			if (alarmLevel.equals(AlarmFilterPreferencePage.ALARM_LEVEL_ERROR)) {
				isHit = true;
			}
		}
		return isHit;
	}

	/*
	 * Trap𑗐M܂B
	 * 
	 */
	private void sendTrap(String message, String alarmLevel, String alarmCode) {

		String tragetServerAddress = AlarmTrapResourceFileParse.getInstance()
				.getServerAddress();
		String hostAddress = "";
		String community = DEFAULT_COMMUNITY;

		try {
			InetAddress host = InetAddress.getByName(tragetServerAddress);
			hostAddress = host.getHostAddress();
		} catch (UnknownHostException e2) {
			logger.warning("UnknownHostException " + e2.getMessage());
			return;
		}

		version = SnmpPreference.SNMP_VERSION_1;
		try {
			SnmpSequence trapPDUSequence = createTrapPDU(hostAddress,
					community, message, alarmLevel, alarmCode);
			if (trapPDUSequence != null) {
				// TrapM
				AgentDispatcher dispacher = new AgentDispatcher();
				dispacher.dispacherTrapSend(hostAddress, version, community,
						trapPDUSequence);

			} else {
				logger.warning("Trap PDU Sequence is null.");
			}
		} catch (SocketException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

		} catch (UnknownHostException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

		} catch (SnmpV3ConfigurationException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

		} catch (GeneralSecurityException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

		} catch (SnmpBadValueException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

		} catch (IOException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

		}
	}

	/*
	 * TrapMPDU𐶐ĕԂ܂B
	 * 
	 * @param hostAddress MAhX
	 * @param community R~jeB
	 * @return SnmpSequence TrapMPDU
	 */
	private SnmpSequence createTrapPDU(String hostAddress, String community,
			String message, String alarmLevel, String alarmCode) {

		SnmpSequence trapPDUSequence = null;
		AgentTrapPDU trapPdu = AgentTrapPDU.getInstance();

		String enterpriseOID = AlarmTrapPreference.NETJFWATCHER_TRAP_OID;
		String additionalVariableOID = AlarmTrapPreference.NETJFWATCHER_TRAP_OID;
		int genericTrap = AgentTrapSendView.ENTERPRISESPECIFIC_NUMBER;
		int specificTrap = AlarmTrapPreference.TRAP_SPECIFIC_CODE_INFO_LEVEL;
		if (alarmLevel.equals(AlarmFilterPreferencePage.ALARM_LEVEL_INFO)) {
			specificTrap = AlarmTrapPreference.TRAP_SPECIFIC_CODE_INFO_LEVEL;
			additionalVariableOID = AlarmTrapPreference.NETJFWATCHER_TRAPS_INFO;
		} else if (alarmLevel
				.equals(AlarmFilterPreferencePage.ALARM_LEVEL_WARNING)) {
			specificTrap = AlarmTrapPreference.TRAP_SPECIFIC_CODE_WARNING_LEVEL;
			additionalVariableOID = AlarmTrapPreference.NETJFWATCHER_TRAPS_WARNING;
		} else if (alarmLevel
				.equals(AlarmFilterPreferencePage.ALARM_LEVEL_ERROR)) {
			specificTrap = AlarmTrapPreference.TRAP_SPECIFIC_CODE_ERROR_LEVEL;
			additionalVariableOID = AlarmTrapPreference.NETJFWATCHER_TRAPS_ERROR;
		}

		String agentIPAddress = "";
		try {
			InetAddress localAddress = InetAddress.getLocalHost();
			agentIPAddress = localAddress.getHostAddress();
		} catch (UnknownHostException e) {
			logger.warning("UnknownHostException " + e.getMessage());
			e.printStackTrace();
			return null;
		}

		String valueString = message;
		String valueTypeString = SnmpBERCodec.SNMPOCTETSTRING;
		try {
			trapPDUSequence = trapPdu.createV1TrapPDU(agentIPAddress,
					enterpriseOID, genericTrap, specificTrap,
					additionalVariableOID, valueString, valueTypeString, false);

			logger.info("Sent trap to " + hostAddress);

			logger.info("  enterprise OID:     "
					+ ((SnmpTrapPDU) trapPDUSequence).getEnterpriseOID()
							.toString());
			logger.info("  agent address:      "
					+ ((SnmpTrapPDU) trapPDUSequence).getAgentAddress()
							.toString());
			logger.info("  generic trap:       "
					+ ((SnmpTrapPDU) trapPDUSequence).getGenericTrap());
			logger.info("  specific trap:      "
					+ ((SnmpTrapPDU) trapPDUSequence).getSpecificTrap());
			logger.info("  timestamp:          "
					+ ((SnmpTrapPDU) trapPDUSequence).getTimestampData());
			logger.info("  supplementary vars: "
					+ ((SnmpTrapPDU) trapPDUSequence).getVarBindList()
							.toString());

		} catch (SnmpBadValueException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();
			return null;
		}

		return trapPDUSequence;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static SenderAlarmTrap getInstance() {
		return SingletonResource.ALARM_TRAP_INSTANCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final SenderAlarmTrap ALARM_TRAP_INSTANCE = new SenderAlarmTrap();
	}
}
