/*
 * Created on 2004/04/06
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.nodecontrol.NodeDelete;
import netjfwatcher.engine.socket.CommandInfo;


/**
 * m[h폜s\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandNodeDelete extends TemplateCommandImpl {
    // MO
    private static Logger logger;

    /**
     * m[h폜s܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());
        logger.info("Delete Node IP=" + com.getIpaddress());

        NodeDelete nodeDelete = NodeDelete.getInstance();
        nodeDelete.deleteNode(com);

        sendResponse(CommandMappingTableResource.ACK_RESPONSE, ois, oos);
    }
}
