/*
 * Created on 2004/05/14
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.ResourceInfo;


/**
 * \[X擾܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandResourceGet extends TemplateCommandImpl {
    // MO
    private static Logger logger;

    /**
     * \[X擾WebɕԂ܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        ResourceInfo resourceInfo =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo();

        resourceInfo.setSnmpV3ConfigMapList(
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3ConfigAddresssMapList());

        Iterator it = null;
        Map list =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3ConfigAddresssMapList();

        /* Snmp ManagerƂāAAgentAhX̊Ďlogging\ */
        for (it = list.keySet().iterator(); it.hasNext();) {
            String key = (String) it.next();
            SnmpV3ManagerConfigInfo snmpManagerConfigInfo =
                (SnmpV3ManagerConfigInfo) list.get(key);

            if (snmpManagerConfigInfo == null) {
                continue;
            }

            logger.info(
                "Snmp Agent address : " + snmpManagerConfigInfo.getIpAddress());
            logger.info(
                "Snmp Agent contextName : "
                + snmpManagerConfigInfo.getContextName());
            logger.info(
                "Snmp Agent SnmpEngineID : "
                + snmpManagerConfigInfo.getSnmpEngineID());
            logger.info(
                "Snmp Agent SnmpEngineBoots : "
                + snmpManagerConfigInfo.getSnmpEngineBoots());
            logger.info(
                "Snmp Agent SnmpEngineTime : "
                + snmpManagerConfigInfo.getSnmpEngineTime());
            logger.info("");
        }

        sendResponse(resourceInfo, ois, oos);
    }
}
