/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.database.access.model.DBTableTaskSchedule;
import netjfwatcher.engine.nodecontrol.NodeAdd;
import netjfwatcher.engine.server.taskschedule.TaskScheduleControl;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;



/**
 * f[^x[Xm[hĎǂݍŃm[hĎThread
 * N郁\bhNXłB
 * GWNŃf[^x[XȂꍇɂ̃NX
 * \bhĂ΂܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class DatabaseLoad {
    /* MO */
    private static Logger logger;

    /*
     * f[^x[Xm[hĎǂݍŃm[hĎThread
     * N郁\bhNXCX^X𐶐܂B
     */
    private DatabaseLoad() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * GWNɃf[^x[X̏ȂꍇɌĂ΂A
     * m[hĎf[^x[XǂݍŃm[hĎThread
     * N܂B
     *
     */
    public void loadDatabase() {
        DBTableNodeRegister nodeRegisterDBTable =
            DBTableNodeRegister.getInstance();
        ArrayList nodeList = null;
        Shell shell = new Shell();

        try {
            nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
        } catch (SQLException e1) {
            MessageDialog.openError(
                shell, "Node List import error", e1.getMessage());
            logger.warning("Node List import error " + e1.getMessage());
            e1.printStackTrace();

            return;
        } catch (Exception e1) {
            MessageDialog.openError(
                shell, "Node List import error", e1.getMessage());
            logger.warning("Node List import error " + e1.getMessage());
            e1.printStackTrace();

            return;
        } finally {
            shell.dispose();
        }

        shell = new Shell();

        /* m[hĎThreadN */
        for (int i = 0; i < nodeList.size(); i++) {
            NodeInformation nodeInfo = (NodeInformation) nodeList.get(i);
            NodeAdd nodeAddInstance = NodeAdd.getInstance();

            /* f[^x[Xe[uȂŃm[hĎThreadN */
            nodeAddInstance.addNode(nodeInfo, false);
        }

        try {
            setTaskSchedule();
        } catch (DatabaseConnectionException e1) {
            logger.warning(
                "Abort Database Schedule Table load " + e1.getMessage());
            MessageDialog.openError(
                shell, "Abort Database Schedule Table load",
                "Abort Database Schedule Table load "
                + "by DatabaseConnectionException " + e1.getMessage());
            e1.printStackTrace();

            return;
        } catch (SQLException e1) {
            MessageDialog.openError(
                shell, "Abort Database Schedule Table load",
                "Abort Database Schedule Table load by SQLException "
                + e1.getMessage());
            e1.printStackTrace();

            return;
        } finally {
            shell.dispose();
        }
    }

    /**
     * ^XNXPW[f[^x[XǂݍŃZbg܂B
     *
     * @throws DatabaseConnectionException f[^x[XRlNV擾oȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    private void setTaskSchedule()
        throws DatabaseConnectionException, SQLException {
        DBTableTaskSchedule taskSchedule = DBTableTaskSchedule.getInstance();

        ArrayList list = taskSchedule.findAll();

        for (int i = 0; i < list.size(); i++) {
            TaskScheduleInfo info = (TaskScheduleInfo) list.get(i);

            TaskScheduleControl.getInstance().setTaskSchedule(info);
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static DatabaseLoad getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final DatabaseLoad RESOURCE = new DatabaseLoad();
    }
}
