/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.util.logging.Logger;

import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmp;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;



/**
 * m[hTreeɂTreeIXi[NXłB
 * TreȇIm[hSnmpm[hViewOpen܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ListenerNodeSnmpViewTree implements ISelectionChangedListener {
    /* MO */
    private static Logger logger = null;

    /**
         * * m[hTreeɂTreeIXi[NXCX^X𐶐܂B
         */
    public ListenerNodeSnmpViewTree() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /** e[uViewɃtB[hꗗőIGg͒lƂĐݒ
     * ̃Cxg_@ƂWebɃANZX
     *
     * @param event SelectionChangedEvent
     */
    public void selectionChanged(SelectionChangedEvent event) {
        //
        StructuredSelection ss = (StructuredSelection) event.getSelection();

        // m[hGroup̏ꍇɂ̓uEUopenreturn
        logger.info("Tree node  select : " + ss.getFirstElement());

        if (ss.getFirstElement() instanceof NodeTreeGroup) {
            logger.info("NodeTreeGroup ");

            return;
        } else if (!(ss.getFirstElement() instanceof NodeTree)) {
            logger.info("No NodeTree ");

            return;
        }

        final NodeTree entry = (NodeTree) ss.getFirstElement();

        IWorkbenchPage activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        try {
            /*
             * IꂽGg̃m[hURLEditorɃuEU
             * I[v
             * EditorID̓uEŨNX
             */
            activePage.openEditor(
                new EditorInputNodeView(
                    entry.getName() + EditorNodeSnmp.TITLE_SUFFIX,
                    entry.getNodeInfo(), false), EditorNodeSnmp.class.getName());
        } catch (PartInitException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }
}
