/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.engine.common.model.NodeInformationXMLTag;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;



/**
 * m[hĎƃm[hMap񂩂XML`̃m[h𐶐A
 * fileɕۑ郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeListExport {

    private static Logger logger;


    public NodeListExport() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hĎƃm[hMap񂩂XML𐶐܂B
     *
     * @param nodeInfoList m[hĎ񃊃Xg
     * @param nodMapLinkinfo m[hMap
     * @return Document
     */
    public Document updateDocument(
        ArrayList nodeInfoList, NodeMapLinkInformation nodMapLinkinfo) {
        /*  */
        Element confElement = new Element(NodeInformationXMLTag.ROOT_TAG);
        Document document = new Document(confElement);


        if ((nodeInfoList != null) && (nodeInfoList.size() > 0)) {
            Element nodeInfoRoot =
                new Element(NodeInformationXMLTag.NODE_INFO_ROOT_TAG);

            Element[] nodeInfo = new Element[nodeInfoList.size()];

            Element[] nodeName = new Element[nodeInfoList.size()];
            Element[] ipAddress = new Element[nodeInfoList.size()];
            Element[] nodeGroup = new Element[nodeInfoList.size()];
            Element[] engineAddress = new Element[nodeInfoList.size()];
            Element[] nodeX = new Element[nodeInfoList.size()];
            Element[] nodeY = new Element[nodeInfoList.size()];
            Element[] nodeKind = new Element[nodeInfoList.size()];
            Element[] pingPeriod = new Element[nodeInfoList.size()];
            Element[] pingThreshold = new Element[nodeInfoList.size()];
            Element[] snmpVersion = new Element[nodeInfoList.size()];
            Element[] snmpLevel = new Element[nodeInfoList.size()];
            Element[] snmpPeriod = new Element[nodeInfoList.size()];
            Element[] snmpROCommunity = new Element[nodeInfoList.size()];
            Element[] snmpRWCommunity = new Element[nodeInfoList.size()];
            Element[] snmpTimeout = new Element[nodeInfoList.size()];
            Element[] httpPeriod = new Element[nodeInfoList.size()];
            Element[] httpPort = new Element[nodeInfoList.size()];
            Element[] httpUrl = new Element[nodeInfoList.size()];
            Element[] httpTimeout = new Element[nodeInfoList.size()];
            Element[] pop3Period = new Element[nodeInfoList.size()];
            Element[] pop3Port = new Element[nodeInfoList.size()];
            Element[] pop3Timeout = new Element[nodeInfoList.size()];
            Element[] pop3User = new Element[nodeInfoList.size()];
            Element[] pop3Password = new Element[nodeInfoList.size()];
            Element[] smtpPeriod = new Element[nodeInfoList.size()];
            Element[] smtpPort = new Element[nodeInfoList.size()];
            Element[] smtpTimeout = new Element[nodeInfoList.size()];
            Element[] smtpSendAddress = new Element[nodeInfoList.size()];
            Element[] smtpCheckPopHost = new Element[nodeInfoList.size()];
            Element[] smtpCheckPopPort = new Element[nodeInfoList.size()];
            Element[] smtpCheckPopTimeout = new Element[nodeInfoList.size()];
            Element[] smtpCheckPopUser = new Element[nodeInfoList.size()];
            Element[] smtpCheckPopPassword = new Element[nodeInfoList.size()];

            confElement.addContent(nodeInfoRoot);

            for (int i = 0; i < nodeInfoList.size(); i++) {
                NodeInformation nodeInformation =
                    (NodeInformation) nodeInfoList.get(i);

                nodeInfo[i] = new Element(NodeInformationXMLTag.NODE_INFO_TAG);
                nodeName[i] = new Element(NodeInformationXMLTag.NODENAME);
                ipAddress[i] = new Element(NodeInformationXMLTag.IPADDRESS);
                nodeGroup[i] = new Element(NodeInformationXMLTag.GROUP);
                engineAddress[i] =
                    new Element(NodeInformationXMLTag.ENGINE_ADDRESS);
                nodeX[i] = new Element(NodeInformationXMLTag.NODE_X);
                nodeY[i] = new Element(NodeInformationXMLTag.NODE_Y);
                nodeKind[i] = new Element(NodeInformationXMLTag.NODEKIND);
                pingPeriod[i] = new Element(NodeInformationXMLTag.PING_PERIOD);
                pingThreshold[i] =
                    new Element(NodeInformationXMLTag.PING_THRESHHOLD);
                snmpVersion[i] =
                    new Element(NodeInformationXMLTag.SNMP_VERSION);
                snmpLevel[i] = new Element(NodeInformationXMLTag.SNMP_LEVEL);
                snmpPeriod[i] = new Element(NodeInformationXMLTag.SNMP_PERIOD);
                snmpROCommunity[i] =
                    new Element(NodeInformationXMLTag.SNMP_ROCOMMUNITY);
                snmpRWCommunity[i] =
                    new Element(NodeInformationXMLTag.SNMP_RWCOMMUNITY);
                snmpTimeout[i] =
                    new Element(NodeInformationXMLTag.SNMP_TIMEOUT);
                httpPeriod[i] = new Element(NodeInformationXMLTag.HTTP_PERIOD);
                httpPort[i] = new Element(NodeInformationXMLTag.HTTP_PORT);
                httpUrl[i] = new Element(NodeInformationXMLTag.HTTP_URL);
                httpTimeout[i] =
                    new Element(NodeInformationXMLTag.HTTP_TIMEOUT);

                pop3Period[i] = new Element(NodeInformationXMLTag.POP3_PERIOD);
                pop3Port[i] = new Element(NodeInformationXMLTag.POP3_PORT);
                pop3Timeout[i] =
                    new Element(NodeInformationXMLTag.POP3_TIMEOUT);
                pop3User[i] = new Element(NodeInformationXMLTag.POP3_USER);
                pop3Password[i] =
                    new Element(NodeInformationXMLTag.POP3_PASSWORD);
                smtpPeriod[i] = new Element(NodeInformationXMLTag.SMTP_PERIOD);
                smtpPort[i] = new Element(NodeInformationXMLTag.SMTP_PORT);
                smtpTimeout[i] =
                    new Element(NodeInformationXMLTag.SMTP_TIMEOUT);
                smtpSendAddress[i] =
                    new Element(NodeInformationXMLTag.SMTP_SEND_ADDRESS);
                smtpCheckPopHost[i] =
                    new Element(NodeInformationXMLTag.SMTP_CHECK_POP3_HOST);
                smtpCheckPopPort[i] =
                    new Element(NodeInformationXMLTag.SMTP_CHECK_POP3_PORT);
                smtpCheckPopTimeout[i] =
                    new Element(NodeInformationXMLTag.SMTP_CHECK_POP3_TIMEOUT);
                smtpCheckPopUser[i] =
                    new Element(NodeInformationXMLTag.SMTP_CHECK_POP3_USER);
                smtpCheckPopPassword[i] =
                    new Element(NodeInformationXMLTag.SMTP_CHECK_POP3_PASSWORD);

                nodeInfoRoot.addContent(nodeInfo[i]);

                nodeInfo[i].addContent(nodeName[i]);
                nodeInfo[i].addContent(ipAddress[i]);
                nodeInfo[i].addContent(nodeGroup[i]);
                nodeInfo[i].addContent(engineAddress[i]);
                nodeInfo[i].addContent(nodeX[i]);
                nodeInfo[i].addContent(nodeY[i]);
                nodeInfo[i].addContent(nodeKind[i]);
                nodeInfo[i].addContent(pingPeriod[i]);
                nodeInfo[i].addContent(pingThreshold[i]);
                nodeInfo[i].addContent(snmpVersion[i]);
                nodeInfo[i].addContent(snmpLevel[i]);
                nodeInfo[i].addContent(snmpPeriod[i]);
                nodeInfo[i].addContent(snmpROCommunity[i]);
                nodeInfo[i].addContent(snmpRWCommunity[i]);

                nodeInfo[i].addContent(httpPeriod[i]);
                nodeInfo[i].addContent(httpPort[i]);
                nodeInfo[i].addContent(httpTimeout[i]);
                nodeInfo[i].addContent(httpUrl[i]);

                nodeInfo[i].addContent(pop3Period[i]);
                nodeInfo[i].addContent(pop3Port[i]);
                nodeInfo[i].addContent(pop3Timeout[i]);
                nodeInfo[i].addContent(pop3User[i]);
                nodeInfo[i].addContent(pop3Password[i]);

                nodeInfo[i].addContent(smtpPeriod[i]);
                nodeInfo[i].addContent(smtpPort[i]);
                nodeInfo[i].addContent(smtpTimeout[i]);
                nodeInfo[i].addContent(smtpSendAddress[i]);

                nodeInfo[i].addContent(smtpCheckPopHost[i]);
                nodeInfo[i].addContent(smtpCheckPopPort[i]);
                nodeInfo[i].addContent(smtpCheckPopTimeout[i]);
                nodeInfo[i].addContent(smtpCheckPopUser[i]);
                nodeInfo[i].addContent(smtpCheckPopPassword[i]);

                nodeName[i].setText(nodeInformation.getNodename());
                ipAddress[i].setText(nodeInformation.getIpaddress());
                nodeGroup[i].setText(nodeInformation.getGroup());
                engineAddress[i].setText(nodeInformation.getEngineAddress());
                nodeX[i].setText(nodeInformation.getNodeX());
                nodeY[i].setText(nodeInformation.getNodeY());
                nodeKind[i].setText(nodeInformation.getNodeKind());

                pingPeriod[i].setText(nodeInformation.getPingPeriod());
                pingThreshold[i].setText(nodeInformation.getPingThreshold());
                snmpVersion[i].setText(nodeInformation.getSnmpVersion());
                snmpLevel[i].setText(nodeInformation.getSnmpLevel());
                snmpPeriod[i].setText(nodeInformation.getSnmpPeriod());
                snmpROCommunity[i].setText(nodeInformation.getRoCommunity());
                snmpRWCommunity[i].setText(nodeInformation.getRwCommunity());

                httpPeriod[i].setText(nodeInformation.getHttpPeriod());
                httpPort[i].setText(nodeInformation.getHttpPort());
                httpTimeout[i].setText(nodeInformation.getHttpTimeout());
                httpUrl[i].setText(nodeInformation.getHttpUrl());

                pop3Period[i].setText(nodeInformation.getPopPeriod());
                pop3Port[i].setText(nodeInformation.getPopPort());
                pop3Timeout[i].setText(nodeInformation.getPopTimeout());
                pop3User[i].setText(nodeInformation.getPopUser());
                pop3Password[i].setText(nodeInformation.getPopPassword());

                smtpPeriod[i].setText(nodeInformation.getSmtpPeriod());
                smtpPort[i].setText(nodeInformation.getSmtpPort());
                smtpTimeout[i].setText(nodeInformation.getSmtpTimeout());
                smtpSendAddress[i].setText(
                    nodeInformation.getSmtpSendAddress());

                smtpCheckPopHost[i].setText(nodeInformation.getSmtpCheckHost());
                smtpCheckPopPort[i].setText(nodeInformation.getSmtpCheckPort());
                smtpCheckPopTimeout[i].setText(
                    nodeInformation.getSmtpCheckTimeout());
                smtpCheckPopUser[i].setText(nodeInformation.getSmtpCheckUser());
                smtpCheckPopPassword[i].setText(
                    nodeInformation.getSmtpCheckPassword());
            }
        }

        if (nodMapLinkinfo != null) {
            ArrayList node0List = nodMapLinkinfo.getNode0address();
            ArrayList node1List = nodMapLinkinfo.getNode1address();

            if (
                ((node0List != null) && (node0List.size() > 0))
                    && ((node1List != null) && (node1List.size() > 0))) {
                /*  */
                Element linkInfoRoot =
                    new Element(NodeInformationXMLTag.LIN_INFO_ROOT_TAG);
                confElement.addContent(linkInfoRoot);

                Element[] linkInfo = new Element[node0List.size()];
                Element[] linkX = new Element[node0List.size()];
                Element[] linkY = new Element[node0List.size()];

                for (int i = 0; i < node0List.size(); i++) {
                    linkInfo[i] =
                        new Element(NodeInformationXMLTag.LIN_INFO_TAG);
                    linkX[i] = new Element(NodeInformationXMLTag.LINK_X);
                    linkY[i] = new Element(NodeInformationXMLTag.LINK_Y);

                    /*  */
                    linkInfoRoot.addContent(linkInfo[i]);
                    linkInfo[i].addContent(linkX[i]);
                    linkInfo[i].addContent(linkY[i]);
                    linkX[i].setText((String) node0List.get(i));
                    linkY[i].setText((String) node1List.get(i));
                }
            }
        }

        return document;
    }

    /**
     *@wBufferedWriteryDocumentXML Fileɏo͂܂B
     *
     * @param bufWriter
     * @param dom
     */
    public void outputXMLFile(String fileName, Document dom) {
        logger = Logger.getLogger(this.getClass().getName());

        File f = new File(fileName);
        logger.info("Path : " + f.getAbsolutePath());

        if (f == null) {
            return;
        }

        BufferedWriter bufWriter = null;

        try {
            FileWriter fi = new FileWriter(fileName);
            bufWriter = new BufferedWriter(fi);
        } catch (IOException e1) {
            e1.printStackTrace();

            return;
        }

        /*
         * qGgeGg2wAGgԂ̉s
         * w͂ȂiXMLt@CŌXsĂ邽߁j
         */
        XMLOutputter outputter =
            XMLOutputterFormat.getInstance().getXMLOutputterFormat();

        try {
            outputter.output(dom, System.out);
            outputter.output(dom, bufWriter);
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        } finally {
            if (bufWriter != null) {
                try {
                    bufWriter.close();
                } catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }
}
