/*
 * Created on 2004/05/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.nodewatchinfo.OidGetInfo;
import netjfwatcher.engine.nodewatchinfo.StatisticsMibInfo;



/**
 * ISNMPvMIB̎悷m[h̃XgIɓǂŃL[PushThread
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ThreadListReadQueuePushStatisticMibControl implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger = null;

    /**
     * ISNMPvMIB̎悷m[h̃XgIɓǂŃL[Push
     * ThreadNXCX^X𐶐܂B
     */
    public ThreadListReadQueuePushStatisticMibControl() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ISNMPvMIB̎悷m[h̃XgIɓǂŃL[Push܂B
     *
     */
    public void run() {
        int count = 0;
        Iterator it = null;

        while (true) {
            // vMIB̎m[hXgǂݍ
            Map list =
                ListQueueStatisticsMibControl.getInstance()
                                             .getStatisticsMibHashMap();

            for (it = list.entrySet().iterator(); it.hasNext();) {
                Map.Entry ent = (Map.Entry) it.next();

                String keyIpAddress = (String) ent.getKey();

                NodeWatchInfo nodeInfo =
                    BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                        keyIpAddress);

                if (
                    (nodeInfo == null)
                        || !nodeInfo.getStatisticsMIBStatus().equals(AbstractQueueForProtocolCheck.OK_STATUS)) {
                    continue;
                }

                StatisticsMibInfo info =
                    (StatisticsMibInfo) list.get(keyIpAddress);

                if (info == null) {
                    continue;
                }

                Iterator it2 = null;
                Map oidInfoMap = info.getOidList();

                if (oidInfoMap == null) {
                    continue;
                }

                for (it2 = oidInfoMap.entrySet().iterator(); it2.hasNext();) {
                    Map.Entry ent2 = (Map.Entry) it2.next();
                    String keyOid = (String) ent2.getKey();
                    OidGetInfo oidGetInfo = (OidGetInfo) oidInfoMap.get(keyOid);

                    // Statistics Mib ̎o
                    count = Integer.parseInt(oidGetInfo.getCountGetMibPeriod());

                    if (count != 0) {
                        count--;
                        oidGetInfo.setCountGetMibPeriod(
                            Integer.toString(count));
                        info.updateOid(keyOid, oidGetInfo);
                        ListQueueStatisticsMibControl.getInstance()
                                                     .updateStatisticsMibGetNode(
                            keyIpAddress, info);

                        if (count == 0) {
                            // Mib getsL[Push
                            QueueForStatisticsMib.getInstance().pushQue(
                                oidGetInfo);

                            // Mib getJE^Zbg
                            oidGetInfo.setCountGetMibPeriod(
                                oidGetInfo.getGetMibPeriod());
                            info.updateOid(keyOid, oidGetInfo);
                            ListQueueStatisticsMibControl.getInstance()
                                                         .updateStatisticsMibGetNode(
                                keyIpAddress, info);

                            // }
                        }
                    }
                }
            }

            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
