/*
 * Created on 2004/05/02
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.ping;

import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTablePingResponse;
import netjfwatcher.database.access.model.LastCheckTimeUpDate;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmMessageResource;
import netjfwatcher.engine.alarm.AlarmRecovery;

/**
 * PingĎs\bhNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ExecutePing {
	/* MO */
	private static Logger logger;

	/* pingsGW */
	private PingExcecEngine execPingInstance = new PingExcecEngine(null, null);

	/**
	 * PingsCX^X𐶐܂B
	 * 
	 */
	public ExecutePing() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * PingsAʂmFăf[^x[XɊi[܂B
	 * 
	 * @param targetIPAddress
	 *            PingsΏIPAhX
	 * @param pingThreshold
	 *            Ping臒l
	 */
	public synchronized void executePing(String targetIPAddress, int pingThreshold) {
		/* PingsIPAhXZbg */
		execPingInstance.setTargetIPAddress(targetIPAddress);

		/* PingsԃftHglZbg */
		long diffTime = -1;

		if (execPingInstance.checkPingResponse()) {
			/* ԃ`FbN */
			diffTime = execPingInstance.getDifftime();

			if (diffTime > pingThreshold) {
				/*
				 * PingԂ臒lI[o[ꍇɃA[ bZ[WA[L[Put
				 */
				AlarmMessageMake message = AlarmMessageMake.getInstance();
				message
						.setPingResOver(targetIPAddress, diffTime,
								pingThreshold);
			} else {
				/*
				 * PingԂ臒lȓŐȏꍇ
				 */
				diffTime = execPingInstance.getDifftime();

				/*
				 * O񂪉Ԃُō񐳏ŏQ ł邩`FbN
				 */
				if (AlarmRecovery.getInstance().isOccurredAlarmId(
						targetIPAddress,
						AlarmMessageResource.PING_OVER_AT_THRESHHOLD)) {
					/* Ping臒lI[o[Zbg */
					AlarmMessageMake message = AlarmMessageMake.getInstance();
					message.setRecoveryPingResOver(targetIPAddress, diffTime,
							pingThreshold);
				}
				/*
				 * OPing timeoutُō񐳏ŏQ ł邩`FbN
				 */
				if (AlarmRecovery.getInstance().isOccurredAlarmId(
						targetIPAddress, AlarmMessageResource.PING_TIMEOUT)) {
					/* PingTimeoutZbg */
					AlarmMessageMake message = AlarmMessageMake.getInstance();
					message.setRecoveryPingTimeout(targetIPAddress);
				}
			}
		} else {
			/* ȉȂꍇiTimeout܂ށj */
			diffTime = execPingInstance.getDifftime();
		}

		try {
			/* pingsʃf[^DBɊi[ */
			DBTablePingResponse pingres = DBTablePingResponse.getInstance();
			pingres.putPingTable(targetIPAddress, diffTime);
		} catch (DatabaseConnectionException e1) {
			/* f[^x[XANZXُ */
			logger.warning(e1.getMessage());
			e1.printStackTrace();
		} catch (SQLException e) {
			/* f[^x[XANZXُ */
			logger.warning(e.getMessage());
			e.printStackTrace();
		}

		logger.fine(Thread.currentThread().getName()
				+ " : Ping Response Time : " + Long.toString(diffTime) + "ms");

		try {
			/* Ďm[hŏI`FbNԍXV */
			LastCheckTimeUpDate updateLastCheckTime = LastCheckTimeUpDate
					.getInstance();
			updateLastCheckTime.updateCheckTime(targetIPAddress);
		} catch (DatabaseConnectionException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		} catch (SQLException e) {
			logger.warning(e.getMessage());
			e.printStackTrace();
		}
	}
}
