package netjfwatcher.engine.server.protocol.snmp;

import java.net.SocketException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTablePrintMIB;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;


/**
 * SNMP Print(hr) MIB̎悵ăf[^x[XɊi[܂B
 *
 * 1.3.6.1.2.1.25.3.2.1.1 hrDeciceIndex
 * 1.3.6.1.2.1.25.3.2.1.2 hrDeviceType
 * 1.3.6.1.2.1.25.3.2.1.3 hrDeviceDescr
 * 1.3.6.1.2.1.25.3.2.1.4 hrDeviceID
 * 1.3.6.1.2.1.25.3.2.1.5 hrDeviceStatus
 * 1.3.6.1.2.1.25.3.2.1.6 hrDeviceErrors
 * 1.3.6.1.2.1.25.3.5.1.1 hrPrinterStatus
 * 1.3.6.1.2.1.25.3.5.1.2 hrPrinterDetectedErrorState
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpPrintMibGet {
    /* MO */
    private static Logger logger;

    /*
     * C^tF[XMIB̎OID̔z
     */
    private static final String[] PRINT_OID_ARRAY =
        {
            "1.3.6.1.2.1.25.3.2.1.1", // hrDeciceIndex
            "1.3.6.1.2.1.25.3.2.1.2", // hrDeviceType
            "1.3.6.1.2.1.25.3.2.1.3", // hrDeviceDescr
            "1.3.6.1.2.1.25.3.2.1.4", // hrDeviceID
            "1.3.6.1.2.1.25.3.2.1.5", // hrDeviceStatus
            "1.3.6.1.2.1.25.3.2.1.6", // hrDeviceErrors
            "1.3.6.1.2.1.25.3.5.1.1", // hrPrinterStatus
            "1.3.6.1.2.1.25.3.5.1.2" // hrPrinterDetectedErrorState
        };

    /* m[hIPAhX */
    private String targetIP;

    /* SNMPo[W */
    private int version;

    /* R~jeB */
    private String community;

    /* Print MIBe[uANZXCX^X */
    private final DBTablePrintMIB printMibDBTable;

    /**
     * Snmp Print MIB̎CX^X𐶐܂B
     *
     */
    public SnmpPrintMibGet() {
        logger = Logger.getLogger(this.getClass().getName());
        printMibDBTable = DBTablePrintMIB.getInstance();
    }

    /**
     * Snmp Interface MIB̎ɂăp[^Zbg܂B
     *
     * @param targetIPAddress Target IP Address
     * @param version SNMPo[W
     * @param community R~jeB
     */
    public void setSnmpPrintMibGet(
        final String targetIPAddress, final int version, final String community) {
        this.targetIP = targetIPAddress;
        this.version = version;
        this.community = community;

        // this.snmptablename = snmptablename;
        // this.ValueObject = ValueObject;
        // mibget.setMibGetNext(targetip, version, community);
    }

    /**
     * m[hǉɃm[hPrint MIB̎ŌĂ΂Am[h
     * Print MIB̎悵Af[^x[Xe[uɊi[܂B
     *
     * @throws UnknownHostException AgentAhXs̏ꍇ
     * @throws SocketException Socketsꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     */
    public void getInitialyzePrintMIB()
        throws UnknownHostException, SocketException, SnmpMIBGetException {

        ArrayList[] initialyzePrintList =
            new ArrayList[PRINT_OID_ARRAY.length];
        MibGetNextInfo mibGetInstance = null;

        try {
            int checkCount = 0;

            while (mibGetInstance == null) {
                mibGetInstance =
                    MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(
                        targetIP, Thread.currentThread().getName());

                try {
                    Thread.sleep(MibGetNextInfoQueue.THREAD_WAIT_COUNT);
                } catch (InterruptedException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }

                checkCount++;
                MibGetNextInfoQueue.getInstance().checkTimeout(
                    targetIP, "Initialyze Print MIB", checkCount, version);
            }

            /* Snmp MIB̎̂߂̃p[^Zbg */
            mibGetInstance.setMibGetNext(targetIP, version, community);

            /* Interface MIB̎ */
            for (int i = 0; i < PRINT_OID_ARRAY.length; i++) {
                initialyzePrintList[i] =
                    mibGetInstance.getNextMibValueList(PRINT_OID_ARRAY[i]);

                if (initialyzePrintList[i] == null) {
                    return;
                }
            }

            /* ̎悵Print MIBf[^x[XɊi[ */
            this.setInitialyzeDBPrintMIB(
                targetIP, initialyzePrintList);
            
        } catch (SocketException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIP + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
            throw e;
        } catch (UnknownHostException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIP + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
            throw e;
        } catch (SnmpMIBGetException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIP + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
            throw e;
        } finally {
            /* MIB̎CX^XQueueɉ */
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(
                    targetIP, Thread.currentThread().getName());
            }
        }
    }

    /**
     * m[hPrint MIBĎ܂́Am[hPrint
     * MIB̍ŐV̎掞ɌĂ΂Am[hPrint
     * MIB̎sAf[^x[Xe[u̍XVs܂B
     *
     * @throws UnknownHostException AgentAhXs̏ꍇ
     * @throws SocketException Socketsꍇ
     * @throws SnmpMIBGetException MIB̎Ɏsꍇ
     */
    public void getPrintMIB()
        throws UnknownHostException, SocketException, SnmpMIBGetException {

        ArrayList[] printMibArrayList =
            new ArrayList[PRINT_OID_ARRAY.length];
        MibGetNextInfo mibGetInstance = null;

        try {
            int checkCount = 0;

            while (mibGetInstance == null) {
                mibGetInstance =
                    MibGetNextInfoQueue.getInstance().popMibGetInstanceQueue(
                        targetIP, Thread.currentThread().getName());

                try {
                    Thread.sleep(MibGetNextInfoQueue.THREAD_WAIT_COUNT);
                } catch (InterruptedException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }

                checkCount++;
                MibGetNextInfoQueue.getInstance().checkTimeout(
                    targetIP, "Print MIB", checkCount, version);
            }

            mibGetInstance.setMibGetNext(targetIP, version, community);

            /* Print MIB̎ */
            for (int i = 0; i < PRINT_OID_ARRAY.length; i++) {
                printMibArrayList[i] =
                    mibGetInstance.getNextMibValueList(PRINT_OID_ARRAY[i]);

                if (printMibArrayList[i] == null) {
                    logger.warning(
                        "Abort get Print MIB = " + PRINT_OID_ARRAY[i]);

                    return;
                }
            }

            /* ̎悵Print MIBf[^x[XɊi[ */
            if (printMibArrayList != null) {
                this.setDBPrintMIB(targetIP, printMibArrayList);
            }
        } catch (UnknownHostException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIP + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
            throw e;
        } catch (SocketException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIP + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
            throw e;
        } catch (SnmpMIBGetException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIP + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
            throw e;
        } finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(
                    targetIP, Thread.currentThread().getName());
            }
        }
    }

    /**
     * ̎悵Print MIBlf[^x[XɊi[܂B
     *
     * @param targetip m[hIPAhX
     * @param interfacesList ̎悵Interface MIBli[Xgz
     */
    private void setInitialyzeDBPrintMIB(
        final String targetip, final ArrayList[] interfacesList) {
        try {
            /* e[uInterface MIBi[ */
            printMibDBTable.putSNMPPrint(targetip, interfacesList);

            /*
             * Interface MIB̎悪̂ŁA
             * m[hSNMP\`Ď\ԂɃZbg
             */
            NodeWatchInfo nodeInfo =
                BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(targetip);
            nodeInfo.setPrintMIBStatus(NodeWatchInfo.PRINT_MIB_OK);
            BaseNodeWatchInfoList.getInstance().setNodeWatchInfo(nodeInfo);
        } catch (SQLException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
        } catch (DatabaseConnectionException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetip + " Version=" + version
                + " Community=" + community);
            e.printStackTrace();
        }
    }

    /**
     * Print MIBf[^x[Xe[uXV܂B
     *
     * @param targetIPAddress m[hIPAhX
     * @param interfacesArrayList ̎悵Interface MIBli[Xgz
     */
    private void setDBPrintMIB(
        final String targetIPAddress, final ArrayList[] interfacesArrayList) {
        try {
            printMibDBTable.updateSNMPPrint(
                targetIPAddress, interfacesArrayList);
        } catch (DatabaseConnectionException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIPAddress + " Version="
                + version + " Community=" + community);
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning(
                e.getMessage() + " IP=" + targetIPAddress + " Version="
                + version + " Community=" + community);
            e.printStackTrace();
        }
    }
}