/*
 * Created on 2004/09/28
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;

import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;



/**
 * SNMP}l[WDispatcherNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ManagerDispatcher {
    /* MO */
    private static Logger logger;

    /* ^[QbgAhX */
    private InetAddress targetAddress;

    /* MessageProcessingSubsystem */
    private AbstractManagerMessageProcessingSubsystem messageProcessingSubsystem = null;

    /* R~jeB */
    private String community;

    /** <p>f[^OEpPbg</p> */
    private DatagramSocket dSocket;

    /**
     * SNMP}l[WDispatcherNXCX^X𐶐܂B
     *
     * @throws SocketException SocketɎsꍇ
     */
    public ManagerDispatcher() throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());

        this.dSocket = new DatagramSocket();
    }

    /**
     * SNMP}l[Wł̏fBXpb`̃vpeBZbg܂B
     *
     * @param targetAddressString m[hIPAhX
     * @param community R~jeB
     * @param version SNMPo[W
     * @throws UnknownHostException AhXsȏꍇ
     */
    public void setManagerDispatcher(
        String targetAddressString, String community, int version)
        throws UnknownHostException {
        this.community = community;

        messageProcessingSubsystem = ManagerMPQueue.getInstance().popQueue(
                targetAddressString, version);

        try {
            this.targetAddress = InetAddress.getByName(targetAddressString);
        } catch (UnknownHostException e) {
            AlarmMessageMake alarm = AlarmMessageMake.getInstance();
            alarm.setEorrorUnknownHostException(targetAddressString);

            logger.warning(
                "Abort dispatch to " + targetAddressString + " : "
                + e.getMessage());
            e.printStackTrace();
            throw e;
        }
    }

    /**
     * wSNMPo[WASNMPR}hɂĎwOID̎悵܂B
     *
     * @param version Snmpo[W
     * @param code SnmpR}hR[h
     * @param requestOID vOID
     * @return returnVarBindList Snmp VarBindList
     * @throws SnmpUnmuchRequestIDException MʎqԍMʎqԍƈvȂꍇ
     * @throws SnmpUnmuchRequestMsgIDException SNMP V3̏ꍇŎMmsgIDMmsgIDƈv
     * Ȃꍇ
     * @throws GeneralSecurityException SNMP V3̏ꍇŔF/Í̃ZLeBňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpBadValueException f[^܂͉͂ňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException SNMP V3ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException  SNMP V3F؂ňُ킪ꍇ
     * @throws SnmpMIBGetException MIB̎悪sꍇ
     * @throws SnmpSetException SNMP SetRequestňُ킪ꍇ
     * @throws SnmpConfigurationException SNMP\`ُȏꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\`ُȏꍇ
     * @throws IOException f[^̑Msꍇ
     */
    public SnmpVarBindList dispathGetMessage(
        int version, byte code, String requestOID)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException,
            GeneralSecurityException, SnmpErrorStatusException,
            SnmpBadValueException, SnmpV3DecryptAbortException,
            SnmpV3AuthAbortException, SnmpMIBGetException, SnmpSetException,
            SnmpConfigurationException, SnmpV3ConfigurationException,
            IOException {
        /* SNMPR}h MO */
        setCommandLog(version, code, requestOID);

        /* AgentSnmpVarBindList */
        SnmpVarBindList returnVarBindList = null;

        switch (version) {
        case SnmpPreference.SNMP_VERSION_1:

            /*
             * SNMP V1pManager Message Processing Subsystem
             * ݒ
             */
            messageProcessingSubsystem.setManagerMP(dSocket, targetAddress, community);

            break;

        case SnmpPreference.SNMPV2C:

            /*
             * SNMP V2pManager Message Processing Subsystem
             * ݒ
             */
            messageProcessingSubsystem.setManagerMP(dSocket, targetAddress, community);

            break;

        case SnmpPreference.SNMPV3:

            /*
             * SNMP V3pManager Message Processing Subsystem
             * ݒ
             */
            messageProcessingSubsystem.setManagerMP(dSocket, targetAddress, community);

            break;

        default:
            logger.warning("Bad Snmp version: " + version);
        }

        /*
         * SNMP Manager Message Processing Subsystemsɂ
         * f[^i[
         */
        if (messageProcessingSubsystem != null) {
            returnVarBindList = messageProcessingSubsystem.getProcess(code, requestOID);
        }

        return returnVarBindList;
    }

    /**
     * Set RequestSNMPo[WɑΉDispatch܂B
     *
     * @param version SNMPo[W
     * @param code SNMPR[h
     * @param requestOID OID
     * @param snmpObject SNMPIuWFNg
     * @return SetRequestSNMPVarBindList
     * @throws SnmpUnmuchRequestIDException MʎqԍMʎqԍƈvȂꍇ
     * @throws SnmpUnmuchRequestMsgIDException SNMP V3̏ꍇŎMmsgIDMmsgIDƈv
     * Ȃꍇ
     * @throws GeneralSecurityException SNMP V3̏ꍇŔF/Í̃ZLeBňُ킪ꍇ
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpBadValueException f[^܂͉͂ňُ킪ꍇ
     * @throws SnmpV3DecryptAbortException SNMP V3ňُ킪ꍇ
     * @throws SnmpV3AuthAbortException  SNMP V3F؂ňُ킪ꍇ
     * @throws SnmpMIBGetException MIB̎悪sꍇ
     * @throws SnmpSetException SNMP SetRequestňُ킪ꍇ
     * @throws SnmpConfigurationException SNMP\`ُȏꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\`ُȏꍇ
     * @throws IOException f[^̑Msꍇ
     */
    public SnmpVarBindList dispathSetMessage(
        int version, byte code, String requestOID, AbstractSnmpObject snmpObject)
        throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, 
            GeneralSecurityException, SnmpV3DecryptAbortException, 
            SnmpV3AuthAbortException, SnmpErrorStatusException, 
            SnmpMIBGetException, SnmpSetException, SnmpBadValueException, 
            SnmpConfigurationException, SnmpV3ConfigurationException, 
            IOException {
        setCommandLog(version, code, requestOID);

        messageProcessingSubsystem = null;
        SnmpVarBindList returnVarBindList = null;

        switch (version) {
        case SnmpPreference.SNMP_VERSION_1:
            messageProcessingSubsystem = new ManagerV1MP(dSocket, targetAddress, community);

            break;

        case SnmpPreference.SNMPV2C:
            messageProcessingSubsystem = new ManagerV2MP(dSocket, targetAddress, community);

            break;

        case SnmpPreference.SNMPV3:
            messageProcessingSubsystem = new ManagerV3MP(dSocket, targetAddress, community);

            break;

        default:
            logger.warning("Illegal Snmp Version : " + version);

            return null;
        }

        /* G[WFgSnmp VarBindList擾 */
        returnVarBindList = messageProcessingSubsystem.setProcess(code, requestOID, snmpObject);

        return returnVarBindList;
    }

    /*
     * SNMPR}hMOs܂B
     *
     * @param version SNMPo[W
     * @param code SNMPR}hR[h
     * @param requestOID NGXgOID
     */
    private void setCommandLog(int version, byte code, String requestOID) {
        String snmpVersion = "";

        switch (version) {
        case SnmpPreference.SNMP_VERSION_1:
            snmpVersion = SnmpPreference.SNMPV1_DESCRIPTION;

            break;

        case SnmpPreference.SNMPV2C:
            snmpVersion = SnmpPreference.SNMPV2_DESCRIPTION;

            break;

        case SnmpPreference.SNMPV3:
            snmpVersion = SnmpPreference.SNMPV3_DESCRIPTION;

            break;

        default:
            logger.warning("Bad Snmp version: " + version);

            return;
        }

        String snmpCode = "";

        switch (code) {
        case SnmpBERCodec.SNMPGETREQUEST:
            snmpCode = SnmpBERCodec.COMMAND_GET_REQUEST_DESCRIPTION;

            break;

        case SnmpBERCodec.SNMPGETNEXTREQUEST:
            snmpCode = SnmpBERCodec.COMMAND_GET_NEXT_REQUEST_DESCRIPTION;

            break;

        case SnmpBERCodec.SNMPSETREQUEST:
            snmpCode = SnmpBERCodec.COMMAND_SET_REQUEST_DESCRIPTION;

            break;

        default:
            logger.warning("Undefined SNMP Command code : " + code);

            return;
        }
    }

    /**
     * Close the "connection" with the devive.
     *
     */
    public void closeConnection() {
        if (dSocket != null) {
            dSocket.close();
        }
    }

    /* ( Javadoc)
         * @see java.lang.Object#finalize()
         */
    protected void finalize() throws Throwable {
        super.finalize();

        if (dSocket != null) {
            dSocket.close();
        }
    }
}
