/*
 * Created on 2004/12/16
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket;

import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.socket.info.SystemMib;


/**
 * GWSystem MIB擾郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ConnectionSystemMibGet extends AbstractConnectionEngine {
    /* MO */
    private static Logger logger = null;

    /**
     * GWSystem MIB擾郁\bhNXCX^X
     * 𐶐܂B
     *
     * @param engineAddress GWAhX
     */
    public ConnectionSystemMibGet(final String engineAddress) {
        super(engineAddress);
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hSystem MIB擾܂B
     *
     * @param nodeIPAddress m[hIPAhX
     * @return systemMibInfo System MIB
     * @throws EngineConnectException GWƂ̐ڑňُ킪ꍇ
     * @throws IOException GWƂ̐ڑňُ킪ꍇ
     */
    public SystemMib getSystemMib(final String nodeIPAddress)
        throws EngineConnectException, IOException {
        SystemMib systemMibInfo = null;

        CommandInfo commandInfo = new CommandInfo();
        commandInfo.setCode(
            CommandMappingTableResource.SYSTEM_MIB_GET_COMMAND_ID);
        commandInfo.setIpaddress(nodeIPAddress);

        systemMibInfo = (SystemMib) this.communicationToEngine(commandInfo);
        logger.info("sysDesc     =" + systemMibInfo.getSysDescr());
        logger.info("sysName     =" + systemMibInfo.getSysName());
        logger.info("sysLocation =" + systemMibInfo.getSysLocation());
        logger.info("sysContact  =" + systemMibInfo.getSysContact());
        logger.info("sysSysUpTime=" + systemMibInfo.getSysUpTime());

        return systemMibInfo;
    }
}
