/*
 * Created on 2004/07/14
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.socket.info;

import java.io.Serializable;


/**
 * MIBɊւێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MibInfo implements Serializable {
    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = -9036961811096501738L;

    /* ^[Qbgm[hIPAhX */
    private String ipaddress;

    /* SNMPo[WR[h */
    private int version;

    /* SNMPo[W */
    private String versionString;

    /* ReadR~jeB */
    private String roCommunity;

    /* Read/WriteR~jeB */
    private String rwCommunity;

    /* vOID */
    private String requestMibOid;

    /* MIB OIDZbgl */
    private String oidSetValue;

    /* OID^Cv */
    private String oidType;

    /* Ď */
    private String period;

    /* 臒l */
    private String threshHold;

    /* Ď^Cvi/ώZj*/
    private String threshHoldType;

    /**
     * ^[Qbgm[hIPAhXԂ܂B
     *
     * @return ipaddress ^[Qbgm[hIPAhX
     */
    public String getIpaddress() {
        return ipaddress;
    }

    /**
     * ̎MIB OIDԂ܂B
     *
     * @return requestMibOid ̎MIB OID
     */
    public String getRequestMibOid() {
        return requestMibOid;
    }

    /**
     * ^[Qbgm[hIPAhXZbg܂B
     *
     * @param string ^[Qbgm[hIPAhX
     */
    public void setIpaddress(String string) {
        ipaddress = string;
    }

    /**
     * ̎MIB OIDZbg܂B
     *
     * @param string ̎MIB OID
     */
    public void setRequestMibOid(String string) {
        requestMibOid = string;
    }

    /**
     * MIB OIDZbglZbg܂B
     *
     * @return oidSetValue MIB OIDZbgl
     */
    public String getOidSetValue() {
        return oidSetValue;
    }

    /**
     * OID^CvԂ܂B
     *
     * @return oidType OID^Cv
     */
    public String getOidType() {
        return oidType;
    }

    /**
     * ĎԂ܂B
     *
     * @return period Ď
     */
    public String getPeriod() {
        return period;
    }

    /**
     * 臒lԂ܂B
     *
     * @return threshHold 臒l
     */
    public String getThreshHold() {
        return threshHold;
    }

    /**
     * 臒lĎ^CvԂ܂B
     *
     * @return threshHoldType 臒lĎ^Cv
     */
    public String getThreshHoldType() {
        return threshHoldType;
    }

    /**
     * ̎OIDlZbg܂B
     *
     * @param string ̎OIDl
     */
    public void setOidSetValue(String string) {
        oidSetValue = string;
    }

    /**
     * OID^CvZbg܂B
     *
     * @param string OID^Cv
     */
    public void setOidType(String string) {
        oidType = string;
    }

    /**
     * ĎZbg܂B
     *
     * @param string Ď
     */
    public void setPeriod(String string) {
        period = string;
    }

    /**
     * 臒lZbg܂B
     *
     * @param string 臒l
     */
    public void setThreshHold(String string) {
        threshHold = string;
    }

    /**
     * 臒lĎ^Cvi/ώZjZbg܂B
     *
     * @param string Ď^Cv
     */
    public void setThreshHoldType(String string) {
        threshHoldType = string;
    }

    /**
     * SNMPo[WR[hԂ܂B
     *
     * @return version SNMPo[WR[h
     */
    public int getVersion() {
        return version;
    }

    /**
     * SNMPo[WR[hZbg܂B
     *
     * @param i SNMPo[WR[h
     */
    public void setVersion(int i) {
        version = i;
    }

    /**
     * SNMP ReadR~jeBԂ܂B
     *
     * @return roCommunity SNMP ReadR~jeB
     */
    public String getRoCommunity() {
        return roCommunity;
    }

    /**
     * SNMP Read/WriteR~jeBԂ܂B
     *
     * @return rwCommunity SNMP Read/WriteR~jeB
     */
    public String getRwCommunity() {
        return rwCommunity;
    }

    /**
     * SNMP ReadR~jeBZbg܂B
     *
     * @param string SNMP ReadR~jeB
     */
    public void setRoCommunity(String string) {
        roCommunity = string;
    }

    /**
     * SNMP Read/WriteR~jeBZbg܂B
     *
     * @param string@SNMP Read/WriteR~jeB
     */
    public void setRwCommunity(String string) {
        rwCommunity = string;
    }

    /**
     * SNMPo[WԂ܂B
     *
     * @return versionString SNMPo[W
     */
    public String getVersionString() {
        return versionString;
    }

    /**
     * SNMPo[WZbg܂B
     *
     * @param string SNMPo[W
     */
    public void setVersionString(String string) {
        versionString = string;
    }
}
