/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.jvm;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableGarbageCollection;
import netjfwatcher.engine.garbagecollection.GarbageCollectionMemoryJVM;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionGarbageCollection;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.GarbageCollectionControl;
import netjfwatcher.engine.socket.info.GarbageCollectionInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;


/**
 * JVM Garbage Collection f[^Editor PartɃOt`悷NXłB<br>
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorGarbageCollectionChart extends AbstractEditorNodeChart {
    /* MO */
    private static Logger logger;

    /* JVM Garbage Collection f[^ */
    private static final int DATA_COUNT = 3;

    /* JVM Garbage Collection ̎i[ʒu */
    private static final int DATE_POS = 0;

    /* JVM Garbage Collection Free Memoryi[ʒu */
    private static final int FREE_MEMORY_POS = 1;

    /* JVM Garbage Collection Total Memoryi[ʒu */
    private static final int TOTAL_MEMORY_POS = 2;

    /* Ot`p̃f[^i[Xgyэ̎f[^i[Xg */
    private ArrayList freeMemoryDataList = new ArrayList();
    private ArrayList totalMemoryDataList = new ArrayList();

    /**
     * JVM Garbage Collection Ot\CX^X𐶐܂B
     *
     */
    public EditorGarbageCollectionChart() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * JVM Garbage Collection Ot\ɂPopUpj[
     * Zbg܂B
     *
     * @param parent Popupj[zuComposite
     */
    protected void setPopupMenu(Composite parent) {
        popUpMenu = new Menu(parent.getShell(), SWT.POP_UP);
        canvas.setMenu(popUpMenu);

        /* Sf[^iSOtj` */
        MenuItem menuItemAll = new MenuItem(popUpMenu, SWT.NULL);
        menuItemAll.setText("All");

        /* f[^XVj[ */
        MenuItem menuItemRefresh = new MenuItem(popUpMenu, SWT.NULL);
        menuItemRefresh.setText("Refresh");

        if ((itemNameList != null) && (itemNameList.size() > 1)) {
            MenuItem[] menuItem = new MenuItem[itemNameList.size()];

            /* f[^iOtjj[ */
            for (int i = 0; i < itemNameList.size(); i++) {
                menuItem[i] = new MenuItem(popUpMenu, SWT.NULL);
                menuItem[i].setText((String) itemNameList.get(i));

                final int itemCount = i;
                menuItem[i].addSelectionListener(

                /* ʃOt`f[^IXi[ */
                new SelectionAdapter() {
                        public void widgetSelected(SelectionEvent event) {
                            mode = "";
                            selectNo = itemCount;
                            redraw();
                        }
                    });
            }
        }

        /* Sf[^iSOtj`惊Xi[ */
        menuItemAll.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent event) {
                    mode = ALL_DRAW_MODE;
                    selectNo = 0;
                    redraw();
                }
            });

        /* f[^XVXi[ */
        menuItemRefresh.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent event) {
                    getChartData();

                    mode = ALL_DRAW_MODE;
                    selectNo = 0;
                    redraw();
                }
            });
    }

    /**
     * Ot\f[^ListɃZbgƂƂɁAŏ/ől
     * Zbg܂B
     */
    protected void getChartData() {
        if (maxData == null) {
            maxData = new String[2];
            minData = new String[2];
        }

        long totalMemoryMaxData = 0;
        long totalMemoryMinData = 0;
        long freeMemoryMaxData = 0;
        long freeMemoryMinData = 0;

        dateList.clear();
        allStatisticsDataList.clear();

        freeMemoryDataList.clear();
        totalMemoryDataList.clear();

        GarbageCollectionControl garbageControl = null;
        ArrayList garbageCollectionDataList = null;

        if (!isSocket) {
            /**
            * K[x[WRNVf[^̎
            */
            DBTableGarbageCollection gar =
                DBTableGarbageCollection.getInstance();

            try {
                garbageCollectionDataList = gar.findAll(null, null);
                garbageControl = gar.getDataCount();
            } catch (DatabaseConnectionException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            } catch (SQLException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            } finally {
                gar = null;
            }

            if (garbageControl != null) {
                garbageControl.setThreadState(
                    GarbageCollectionMemoryJVM.getInstance().checkThread());
                garbageControl.setMaxMemory(Runtime.getRuntime().maxMemory());
            }
        } else {
            // System.out.println("Socket");

            String engineAddress =
                ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
            System.out.println("EngineAddress : " + engineAddress);
            garbageControl = null;

            ConnectionGarbageCollection garbage =
                new ConnectionGarbageCollection(engineAddress);

            try {
                garbageControl = garbage.getGarbageCollectionInfo(null, null);
                garbageCollectionDataList =
                    garbageControl.getGarbagCollectionMemoryList();
            } catch (EngineConnectException e) {
                logger.warning("Abort connect engine : " + e.getMessage());
            } catch (IOException e) {
                logger.warning("Abort connect engine : " + e.getMessage());
            }
        }

        if (garbageControl != null) {
            garbageControl.setGarbagCollectionMemoryList(
                garbageCollectionDataList);

            totalMemoryMaxData = garbageControl.getTotalMemoryMaxData();
            totalMemoryMinData = garbageControl.getTotalMemoryMinData();
            freeMemoryMaxData = garbageControl.getFreeMemoryMaxData();
            freeMemoryMinData = garbageControl.getFreeMemoryMinData();

            maxData[0] = Long.toString(freeMemoryMaxData);
            maxData[1] = Long.toString(totalMemoryMaxData);
            minData[0] = Long.toString(freeMemoryMinData);
            minData[1] = Long.toString(totalMemoryMinData);
        }

        if (
            (garbageCollectionDataList == null)
                || (garbageCollectionDataList.size() < 1)) {
            return;
        }

        for (int i = 0; i < garbageCollectionDataList.size(); i++) {
            GarbageCollectionInfo garbageCollectionInfo =
                (GarbageCollectionInfo) garbageCollectionDataList.get(i);

            String[] garbageCollectionTableCellArray = new String[DATA_COUNT];

            garbageCollectionTableCellArray[DATE_POS] =
                garbageCollectionInfo.getCheckDate().toString();
            garbageCollectionTableCellArray[FREE_MEMORY_POS] =
                Long.toString(garbageCollectionInfo.getFreeMemory());
            garbageCollectionTableCellArray[TOTAL_MEMORY_POS] =
                Long.toString(garbageCollectionInfo.getTotalMemory());

            dateList.add(garbageCollectionTableCellArray[DATE_POS]);

            freeMemoryDataList.add(
                garbageCollectionTableCellArray[FREE_MEMORY_POS]);
            totalMemoryDataList.add(
                garbageCollectionTableCellArray[TOTAL_MEMORY_POS]);
        }

        allStatisticsDataList.add(freeMemoryDataList);
        allStatisticsDataList.add(totalMemoryDataList);
    }

    /**
     * Xe[^XC\Zbg܂B
     *
     */
    protected void setStatusLine() {
        /* Xe[^XC\L */
        statusLineManager =
            (SubStatusLineManager) (getEditorSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);
    }
}
