/*
 * Created on 2006/06/28
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.nodedetect;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.filepreference.FilePreference;
import netjfwatcher.engine.model.action.MediaResource;

import org.osgi.framework.Bundle;


/**
 * SNMP sysDecriptorm[hʂ𔻕ʂ邽߂̏Lqt@C
 * ͂ێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class NodeDetectFile {
    /* MO */
    private static Logger logger;

    private NodeDetectFile() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * sysDescm[hʂ邽߂̒`t@C͂AsysDesc
     * ܂܂镶KeyƂm[hʖێMapԂ܂B
     *
     * @return nodeDectMap sysDescɊ܂܂镶KeyƂăm[h
     * ێMap
     */
    public HashMap getNodeDetectMap() {
        HashMap nodeIconMap = MediaResource.getInstance().getIconDataList();

        String fileName = FilePreference.NODE_DETECT_DEFINE_FILE;

        /* sysDescɊ܂܂镶KeyƂăm[hʖێMap */
        HashMap<String, String> nodeDectMap = new HashMap<String, String>();

        int cnt = 0;

        InputStream instream = null;
        InputStreamReader instreamReader = null;
        BufferedReader bufReader = null;

        try {

            URL url = this.getDocumentURL(fileName);
            instream = url.openStream();
            instreamReader = new InputStreamReader(instream);
            bufReader = new BufferedReader(instreamReader);

            String lineString;
            Pattern pattern;
            String[] sysDescJudgeArray;

            while ((lineString = bufReader.readLine()) != null) {
                if (lineString.indexOf("#") >= 0) {
                    // cnt++;
                    continue;
                }

                pattern = Pattern.compile("=");
                sysDescJudgeArray = pattern.split(lineString);

                try {
                    if (sysDescJudgeArray.length != 2) {
                        logger.info(lineString);
                    } else {
                        logger.info(
                            "SysDesc strcat string = " + sysDescJudgeArray[0]);
                        logger.info("Node Kind = " + sysDescJudgeArray[1]);

                        if (nodeIconMap.containsKey(sysDescJudgeArray[1])) {
                            nodeDectMap.put(
                                sysDescJudgeArray[0], sysDescJudgeArray[1]);
                        } else {
                            logger.warning(
                                "Not found node kind = " + sysDescJudgeArray[1]);
                        }
                    }
                } catch (Exception e1) {
                    logger.warning(lineString);
                    e1.printStackTrace();
                }

                cnt++;
            }
        } catch (FileNotFoundException e) {
            // logger.severe("FileNotFoundException : " + filePath);
            e.printStackTrace();
        } catch (IOException e) {
            logger.severe(e.getMessage());
            e.printStackTrace();
        } finally {
            if (bufReader != null) {
                try {
                    bufReader.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (instreamReader != null) {
                try {
                    instreamReader.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (instream != null) {
                try {
                    instream.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }

        return nodeDectMap;
    }

    /**
     * w̃t@CURLԂ܂B
     *
     * @param fileName t@C
     * @return url URL
     */
    public URL getDocumentURL(String fileName) {
        /* 摜肷邽߂PluginResource bundle */
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        URL url = null;
        url = bundle.getEntry(fileName);

        if (url == null) {
            /* bZ[W\[Xt@CȂꍇMO̎ */
            logger.severe("sysDesc defined file : " + fileName);
        }

        return url;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static NodeDetectFile getInstance() {
        return SingletonResource.INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final NodeDetectFile INSTANCE = new NodeDetectFile();
    }
}
