/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.messageformat;


/**
 * ASN.1 BER(Basic Encoding Rule)GR[fBOɂȉ
 * tB[h̊elێNXŁA
 * ETAGԍ
 * EASN.1@BERGR[fBO
 * EASN.1@BERGR[fBOl
 * ̂R\܂B
 * +---------------+------------------+-----------------+
 * | TagtB[h | LengthtB[h | ValuetB[h |
 * +---------------+------------------+-----------------+
 *
 * @see netjfwatcher.snmp.preference.SnmpBERCodec
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SNMPTLV {
    /* TAGԍ */
    private byte tag;

    /* ASN.1@BERGR[fBO */
    private int totalLength;

    /* ASN.1@BERGR[fBOl */
    private byte[] value;

    /**
     * TAGԍԂ܂B
     *
     * @return tag TAGԍ
     */
    public byte getTag() {
        return tag;
    }

    /**
     * TAGԍZbg܂B
     *
     * @param tag TAGԍ
     */
    public void setTag(byte tag) {
        this.tag = tag;
    }

    /**
     * BERGR[fBOԂ܂B
     *
     * @return totalLength BERGR[fBO
     */
    public int getTotalLength() {
        return totalLength;
    }

    /**
     * BERGR[fBOZbg܂B
     *
     * @param totalLength BERGR[fBO
     */
    public void setTotalLength(int totalLength) {
        this.totalLength = totalLength;
    }

    /**
     * BERGR[fBOlԂ܂B
     *
     * @return value BERGR[fBOl
     */
    public byte[] getValue() {
        return value;
    }

    /**
     * BERGR[fBOlZbg܂B
     *
     * @param value BERGR[fBOl
     */
    public void setValue(byte[] value) {
        this.value = value;
    }
}
