/*
 * Created on 2004/12/30
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.bit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;



/**
 * ASN.1 Type(^O)ɂBit(^Oԍ0x03)ɑΉ
 * SNMPIuWFNg𑀍삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpBitString extends AbstractSnmpObject {
    /** <p>l</p> */
    private SnmpBit snmpBitValue;

    /**
     * <p>BitString Data ̃CX^X𐶐܂B</p>
     *
     * @param value l
     */
    public SnmpBitString(SnmpBit value) {
        tag = SnmpBERCodec.SNMPBITSTRING_TAG;
        tagDescription = SnmpBERCodec.SNMPBITSTRING;
        this.snmpBitValue = value;
    }

    /**
     * <p>BitString Data ̃CX^X𐶐܂B</p>
     *
     * @param data byte 
     * @throws SnmpBadValueException f[^sȏꍇɃX[܂B
     */
    public SnmpBitString(byte[] data) throws SnmpBadValueException {
        tag = SnmpBERCodec.SNMPBITSTRING_TAG;
        tagDescription = SnmpBERCodec.SNMPBITSTRING;

        int offset = 0;
        int length = data.length;
        snmpBitValue = decode(data, offset, length);
    }

    /**
     * <p>̃IuWFNg̕\Ԃ܂</p>
     *
     * @return 
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("");

        if (snmpBitValue != null) {
            sb.append("0x");
            sb.append(snmpBitValue.toString());
        }

        return sb.toString();
    }

    /**
     * <p>lԂ܂B</p>
     *
     * @return l
     */
    public Object getValue() {
        return snmpBitValue;
    }

    /**
     * <p>̃IuWFNg̒l Basic Encoding Rule ɏ] byte ɕϊ܂B</p>
     *
     * @return ϊ byte 
     */
    byte[] encode() {
        return encode(snmpBitValue);
    }

    /**
     * <p>w肳ꂽ BITS  Basic Encoding Rule ɏ] byte ɕϊ܂B</p>
     *
     * @param bits BITS
     * @return ϊ byte 
     */
    public byte[] encode(SnmpBit bits) {
        // ltB[h
        byte[] value = null;

        if (bits != null) {
            value = bits.getBEREncoding();
        } else {
            value = new byte[0];
        }

        // tB[h
        Vector vector = new Vector();
        int length = value.length;

        if (length > 127) {
            vector.addElement(new Byte((byte) 0));
            vector.addElement(new Byte((byte) ((length >> 24) & 0xff)));
            vector.addElement(new Byte((byte) ((length >> 16) & 0xff)));
            vector.addElement(new Byte((byte) ((length >> 8) & 0xff)));
            vector.addElement(new Byte((byte) (length & 0xff)));

            for (int i = 0; i < 4; i++) {
                byte b = ((Byte) vector.elementAt(1)).byteValue();

                if (b == 0) {
                    vector.removeElementAt(0);
                } else if (b < 0) {
                    break;
                } else {
                    vector.removeElementAt(0);

                    break;
                }
            }

            vector.insertElementAt(new Byte((byte) (vector.size() | 0x80)), 0);
        } else {
            vector.addElement(new Byte((byte) length));
        }

        // byte 
        byte[] array = new byte[1 + vector.size() + length];
        int index = 0;
        array[index++] = SnmpBERCodec.SNMPBITSTRING_TAG;

        for (int i = 0, li = vector.size(); i < li; i++) {
            array[index++] = ((Byte) vector.elementAt(i)).byteValue();
        }

        vector.removeAllElements();
        System.arraycopy(value, 0, array, index, length);

        return array;
    }

    /**
     * <p>w肳ꂽ byte  Basic Encoding Rule ɏ] BITS ɕϊ܂B</p>
     *
     * @param data byte 
     * @param offset ǂݏoJnʒu
     * @param length (oCg)
     * @return ϊ̒l
     * @throws SnmpBadValueException f[^sȏꍇɃX[܂B
     */
    static SnmpBit decode(byte[] data, int offset, int length)
        throws SnmpBadValueException {
        byte[] bytes = new byte[length];

        try {
            System.arraycopy(data, offset, bytes, 0, length);
        } catch (IndexOutOfBoundsException e) {
            throw new SnmpBadValueException(e.getMessage());
        }

        return new SnmpBit(bytes);
    }

    /**
     * ێĂoCgf[^ASN.1 BERGR[fBOɂăoCgz
     * ϊĕԂ܂B
     *
     * @return oCgz
     */
    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] outBytesArray = null;

        try {
            byte[] data = snmpBitValue.getBEREncoding();

            // calculate encoding for length of data
            byte[] len = this.encodeLength(data.length);

            // encode T,L,V info
            outBytes.write(tag);
            outBytes.write(len, 0, len.length);
            outBytes.write(data, 0, data.length);

            outBytesArray = outBytes.toByteArray();
        } finally {
            try {
                outBytes.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return outBytesArray;
    }

    /**
     * SNMP BitStringCX^XɃf[^Zbg܂B
     *
     * @param newValue ZbgIuWFNgl
     * @throws SnmpBadValueException f[^ZbgɎsꍇ
     */
    public void setValue(Object newValue) throws SnmpBadValueException {
    }
}
