/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.octetstring;

import java.util.StringTokenizer;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;



/**
 * ASN.1 Type(^O)ɂIPADDRESS(^Oԍ 0x40)ɑΉSNMPIuWFNg
 * 삷郁\bhNXIPAhXێ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpIPAddress extends SnmpOctetString {
    /* IPAhX */
    private static final int IPADDRESS_LENGTH = 4;

    /**
     * l 0.0.0.0SNMP IPADDRESSIuWFNg𐶐܂B
     */
    public SnmpIPAddress() {
        /*
         *  initialize to 0.0.0.0
         *  length limited to 4 octets
         */
        dataArray = new byte[IPADDRESS_LENGTH];

        for (int i = 0; i < IPADDRESS_LENGTH; i++) {
            dataArray[i] = 0;
        }

        tag = SnmpBERCodec.SNMPIPADDRESS_TAG;
        tagDescription = SnmpBERCodec.SNMPIPADDRESS;
    }

    /**
     * dot؂IPAhXSNMP IPADDRESSIuWFNg𐶐܂B
     *
     * @param string IPAhX
     * @throws SnmpBadValueException IPAhX񂪈ُȏꍇ
     */
    public SnmpIPAddress(String string) throws SnmpBadValueException {
        this.dataArray = parseIPAddress(string);

        tag = SnmpBERCodec.SNMPIPADDRESS_TAG;
        tagDescription = SnmpBERCodec.SNMPIPADDRESS;
    }

    /**
     * ASN.1 BER encodingf[^ɂSNMP IPADDRESSIuWFNg𐶐܂B
     *
     * @param enc ASN.1 BER encodingf[^
     * @throws SnmpBadValueException SNMP IPADDRESSIuWFNgɎsꍇ
     */
    public SnmpIPAddress(byte[] enc) throws SnmpBadValueException {
        tag = SnmpBERCodec.SNMPIPADDRESS_TAG;
        tagDescription = SnmpBERCodec.SNMPIPADDRESS;

        if (enc.length == IPADDRESS_LENGTH) {
            dataArray = enc;
        } else {
            // wrong size
            throw new SnmpBadValueException(
                " IPAddress: bad BER encoding supplied to set value ");
        }
    }

    /**
     * SNMP IPADDRESSIuWFNgɃf[^Zbg܂B
    *
    * @param newAddress ZbgIuWFNgl
    * @throws SnmpBadValueException f[^ZbgɎsꍇ
     */
    public void setValue(Object newAddress) throws SnmpBadValueException {
        if (
            (newAddress instanceof byte[])
                && (((byte[]) newAddress).length == IPADDRESS_LENGTH)) {
            dataArray = (byte[]) newAddress;
        } else if (newAddress instanceof String) {
            dataArray = parseIPAddress((String) newAddress);
        } else {
            throw new SnmpBadValueException(
                " IPAddress: bad data supplied to set value ");
        }
    }

    /**
     * ێĂIPAhXf[^𕶎ɕϊĕԂ܂B
     *
     * @return returnString IPAhXf[^
     */
    public String toString() {
        String returnString = "";

        if (dataArray.length > 0) {
            int convert = dataArray[0];

            if (convert < 0) {
                convert += 256;
            }

            returnString += convert;

            for (int i = 1; i < dataArray.length; i++) {
                convert = dataArray[i];

                if (convert < 0) {
                    convert += 256;
                }

                returnString += ("." + convert);
            }
        }

        return returnString;
    }

    /**
     * IPAhXoCgzɕϊĕԂ܂B
     *
     * @param addressString IPAhX
     * @return oCgz
     * @throws SnmpBadValueException IPAhX񂩂oCgzւ̕ϊ
     * sꍇ
     */
    private byte[] parseIPAddress(String addressString)
        throws SnmpBadValueException {
        try {
            StringTokenizer st = new StringTokenizer(addressString, " .");
            int size = 0;

            while (st.hasMoreTokens()) {
                // figure out how many values are in string
                size++;
                st.nextToken();
            }

            if (size != IPADDRESS_LENGTH) {
                throw new SnmpBadValueException(
                    " IPAddress: wrong number of components"
                    + " supplied to set value ");
            }

            byte[] returnBytes = new byte[size];

            st = new StringTokenizer(addressString, " .");

            for (int i = 0; i < size; i++) {
                int addressComponent = (Integer.parseInt(st.nextToken()));

                if ((addressComponent < 0) || (addressComponent > 255)) {
                    throw new SnmpBadValueException(
                        " IPAddress: invalid component supplied to set value ");
                }

                returnBytes[i] = (byte) addressComponent;
            }

            return returnBytes;
        } catch (NumberFormatException e) {
            throw new SnmpBadValueException(
                " IPAddress: invalid component supplied to set value ");
        }
    }
}
