/*
 *
 */
package netjfwatcher.snmpagent.preferences;

import java.io.BufferedWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import netjfwatcher.snmp.snmpv3.UsmUserManager;
import netjfwatcher.snmpagent.process.ThreadAgent;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jdom.Document;



/**
 * SNMP V3 Agent Preference PageNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpV3AgentPreferencePage extends PreferencePage
    implements IWorkbenchPreferencePage {
    /* EngineIDeLXg */
    private static final int ENGINEID_TEXT_WIDTH = 250;

    /* eLXg */
    private static final int TEXT_WIDTH = 200;

    /* MO */
    private static Logger logger;

    /* EngineID */
    private Text engineIDText;

    /* Engine Boot */
    private Text engineBootText;

    /* Engine SysupTime */
    private Text engineSysUpTimeText;

    /* User */
    private Text userNameText;

    /* AuthPriv */
    private Combo authPrivCombo;

    /* AuthProtorocol */
    private Combo authProtocolCombo;

    /* AuthPassPhrasa */
    private Text authPassPhrasaText;

    /* PrivProtocol */
    private Text privProtocolText;

    /* PrivPassPhrasa */
    private Text privPassPhrasaText;

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
     */
    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(this.getClass().getName());

        // Initialize the preference store we wish to use
        setPreferenceStore(NetJFWatcherPlugin.getInstance().getPreferenceStore());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.
     * PreferencePage#createContents(Composite)
     */
    protected Control createContents(Composite parent) {
        /* Snmp V3G[WFg\[X擾 */
        SnmpV3AgentConfigInfo snmpV3AgentInfo =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout(layout);

        GridData gridData = null;

        /*
         * Snmp V3 AgentAhXAOIDȂǂzuComposite
         */
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        /* Snmp V3G[WFg EngineID */
        Label label = new Label(composite, SWT.NONE);
        label.setText("EngineID");
        label.setLayoutData(new GridData());
        engineIDText = new Text(composite, SWT.BORDER);
        engineIDText.setText(snmpV3AgentInfo.getSnmpEngineID());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = ENGINEID_TEXT_WIDTH;
        engineIDText.setLayoutData(gridData);

        /* Snmp V3G[WFg Engine Boots */
        label = new Label(composite, SWT.NONE);
        label.setText("EngineBoots");
        label.setLayoutData(new GridData());
        engineBootText = new Text(composite, SWT.BORDER);
        engineBootText.setText(snmpV3AgentInfo.getSnmpEngineBoots());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        engineBootText.setLayoutData(gridData);

        /* Snmp V3G[WFg SysupTime */
        label = new Label(composite, SWT.NONE);
        label.setText("EngineSysUpTime");
        label.setLayoutData(new GridData());
        engineSysUpTimeText = new Text(composite, SWT.BORDER);

        /* SnmpG[WFgStartTimeeLXgZbg */
        Date agentDate = Calendar.getInstance().getTime();

        long agentStartTime = ThreadAgent.getInstance().getStartSnmpAgentEngineTime();
        agentDate.setTime(agentStartTime);

        DateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        engineSysUpTimeText.setText(dateformat.format(agentDate));

        engineSysUpTimeText.setEditable(false);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        engineSysUpTimeText.setLayoutData(gridData);

        /* Snmp V3G[WFg User Name */
        label = new Label(composite, SWT.NONE);
        label.setText("User Name");
        label.setLayoutData(new GridData());
        userNameText = new Text(composite, SWT.BORDER);
        userNameText.setText(snmpV3AgentInfo.getUserName());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        userNameText.setLayoutData(gridData);

        /* Snmp V3G[WFg Auth Priv */
        label = new Label(composite, SWT.NONE);
        label.setText("AuthPriv");
        label.setLayoutData(new GridData());
        authPrivCombo = new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
        authPrivCombo.add(UsmUserManager.AUTHPRIV_NOAUTH);
        authPrivCombo.add(UsmUserManager.AUTHPRIV_AUTH);
        authPrivCombo.add(UsmUserManager.AUTHPRIV_PRIV);
        authPrivCombo.setText(snmpV3AgentInfo.getAuthPriv());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        authPrivCombo.setLayoutData(gridData);

        /* Snmp V3G[WFg Auth Protocol */
        label = new Label(composite, SWT.NONE);
        label.setText("AuthProtocol");
        label.setLayoutData(new GridData());
        authProtocolCombo = new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
        authProtocolCombo.add(UsmUserManager.AUTH_PROTOCOL_MD5);
        authProtocolCombo.add(UsmUserManager.AUTH_PROTOCOL_SHA);
        authProtocolCombo.setText(snmpV3AgentInfo.getAuthProtocol());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        authProtocolCombo.setLayoutData(gridData);

        /* Snmp V3G[WFg Auth PassPhrase */
        label = new Label(composite, SWT.NONE);
        label.setText("AuthPassPhrase");
        label.setLayoutData(new GridData());
        authPassPhrasaText = new Text(composite, SWT.BORDER);
        authPassPhrasaText.setText(snmpV3AgentInfo.getAuthPassPhrase());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        authPassPhrasaText.setLayoutData(gridData);

        /* Snmp V3G[WFg Priv Protocol */
        label = new Label(composite, SWT.NONE);
        label.setText("PrivProtocol");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
        privProtocolText = new Text(composite, SWT.BORDER);
        privProtocolText.setText(snmpV3AgentInfo.getPrivProtocol());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        privProtocolText.setLayoutData(gridData);

        /* Snmp V3G[WFg Priv PassPhrase */
        label = new Label(composite, SWT.NONE);
        label.setText("PrivPassPhrase");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
        privPassPhrasaText = new Text(composite, SWT.BORDER);
        privPassPhrasaText.setText(snmpV3AgentInfo.getPrivPassPhrase());
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        privPassPhrasaText.setLayoutData(gridData);

        return composite;
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
     */
    protected void performDefaults() {
        SnmpV3AgentConfigInfo snmpV3info =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();
        engineIDText.setText(snmpV3info.getSnmpEngineID());
        engineBootText.setText(snmpV3info.getSnmpEngineBoots());

        // engineSysUpTimeText.setText(snmpV3info.getAgentStartTime());
        userNameText.setText(snmpV3info.getUserName());
        authPrivCombo.setText(snmpV3info.getAuthPriv());
        authProtocolCombo.setText(snmpV3info.getAuthProtocol());
        authPassPhrasaText.setText(snmpV3info.getAuthPassPhrase());
        privProtocolText.setText(snmpV3info.getPrivProtocol());
        privPassPhrasaText.setText(snmpV3info.getPrivPassPhrase());
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.PreferencePage#performOk()
     */
    public boolean performOk() {
        SnmpAgentConfigInfo snmpV3AgentConfInfo =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpAgentResourceInfo();
        SnmpV3AgentConfigInfo snmpV3Info =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpV3AgentResourceInfo();

        /* Snmp v3 AgentView text͒lɍXV */
        snmpV3Info.setSnmpEngineBoots(engineBootText.getText());
        snmpV3Info.setUserName(userNameText.getText());
        snmpV3Info.setAuthPriv(authPrivCombo.getText());
        snmpV3Info.setAuthProtocol(authProtocolCombo.getText());
        snmpV3Info.setAuthPassPhrase(authPassPhrasaText.getText());
        snmpV3Info.setPrivProtocol(privProtocolText.getText());
        snmpV3Info.setPrivPassPhrase(privPassPhrasaText.getText());

        /* XV񂩂Document񐶐 */
        Document dom =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .updateDocument(snmpV3AgentConfInfo, snmpV3Info);

        // t@Co̓obt@擾
        BufferedWriter bufWriter = null;
        bufWriter =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getResourceFileWriter();

        // XMLt@Co
        SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                         .outputXMLFile(bufWriter, dom);

        if (bufWriter != null) {
            try {
                bufWriter.close();
            } catch (IOException e) {
                logger.warning(
                    "Abort close BufferedWriter for snmp V3 agent resource : "
                    + e.getMessage());
                e.printStackTrace();
            }
        }

        /* Agentf[^XVAgent Viewɔf */
        if (NetJFWatcherApplication.getAgentOperationView() != null) {
            NetJFWatcherApplication.getAgentOperationView().updateSnmpAgentInfo();
        }

        return super.performOk();
    }
}
