/*
 * Created on 2004/10/16
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmpagent.model.AgentMonitorMessageQueue;


/**
 * SNMPG[WFg̃fBXpb`[ƂāBMf[^̃o[W񂩂
 * o[WɑΉ鏈s܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentDispatcher {
    /* MO */
    private static Logger logger;

    /* Mf[^f[^OSocket */
    private DatagramSocket dSocket;

    /* Mf[^j^[tH[}bg */
    private DateFormat dateformat = new SimpleDateFormat("HH:mm:ss");

    /* SNMPo[W */
    private String snmpVersionDesc = "";

    /* SNMPR}hR[h */
    private String snmpCommandCodeDesc = "";

    /**
     * SNMPG[WFgƂTrapMɐ܂B
     *
     */
    public AgentDispatcher() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SNMPG[WFgƂSNMP}l[W̃R}hMɂĐ
     * ܂B
     *
     * @param dSocket DatagramSocket
     */
    public AgentDispatcher(DatagramSocket dSocket) {
        logger = Logger.getLogger(this.getClass().getName());

        this.dSocket = dSocket;
    }

    /**
     * w̃^[QbgAddressASnmpo[WTrap𑗐M܂B
     *
     * @param targetAddress Snmp Trap𑗐MSnmp}l[W
     * ̃AhX
     * @param version Snmpo[W
     * @param community R~jeB
     * @param pdu Trap PDU
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws UnknownHostException MzXgȂꍇ
     * @throws SnmpV3ConfigurationException TrapMł̃[UGg
     * Ȃꍇ
     * @throws SnmpBadValueException f[^쐬Ɏsꍇ
     * @throws SocketException SocketɎsꍇ
     * @throws IOException TrapMɎsꍇ
     */
    public void dispacherTrapSend(
        String targetAddress, int version, String community, SnmpSequence pdu)
        throws GeneralSecurityException, UnknownHostException, 
            SnmpV3ConfigurationException, SnmpBadValueException, 
            SocketException, IOException {
        logger.info("Version : " + version);
        logger.info("Community : " + community);

        AbstractAgentMessageProcessing mp = null;

        switch (version) {
        case SnmpPreference.SNMP_VERSION_1:
            mp = new AgentV1MP();

            break;

        case SnmpPreference.SNMPV2C:
            mp = new AgentV2MP();

            break;

        case SnmpPreference.SNMPV3:
            mp = new AgentV3MP();

            break;

        default:
            logger.warning("Illegal Trap send version : " + version);
        }

        /* Trap𑗐M */
        mp.sendTrap(targetAddress, community, pdu);
    }

    /**
     * Mf[^SNMPo[WɑΉ鏈s\bhłB
     *
     * @param inPacket f[^MDatagramPacket
     * @param encodedMessage Mf[^̃oCgz
     * @param receiveLength Mf[^
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws SnmpV3ConfigurationException SNMP V3\ňُ킪ꍇ
     * @throws SnmpBadValueException f[^͂܂͐ňُ킪ꍇ
     * @throws IOException f[^Mňُ킪ꍇ
     */
    public void dispath(
        DatagramPacket inPacket, byte[] encodedMessage, int receiveLength)
        throws GeneralSecurityException, SnmpV3ConfigurationException, 
            SnmpBadValueException, IOException {
        /* Mf[^SnmpG[WFgj^[\pZbg */
        Date date = Calendar.getInstance().getTime();
        AgentMonitorMessageQueue.getInstance().pushAgentMessage(
            "Receive date : " + dateformat.format(date) + " : Data length : "
            + receiveLength + "Byte");
        AgentMonitorMessageQueue.getInstance().pushAgentMessage(
            hexBytetoString(encodedMessage, receiveLength));

        int receiveSnmpVersionDispatch = 0;

        SnmpMessage receivedMessage = null;
        AbstractAgentMessageProcessing mp = null;

        // MR}ho
        try {
            receivedMessage = new SnmpMessage();

            SNMPTLV nextTLV = receivedMessage.extractNextTLV(encodedMessage, 0);
            receivedMessage.setTLV(nextTLV);

            /* o[Wcommunity𒊏o */
            byte[] versionByte = receivedMessage.getVersion();
            receiveSnmpVersionDispatch = versionByte[0];

            setSnmpVersion(receiveSnmpVersionDispatch);

            logger.info(
                "Version : " + receiveSnmpVersionDispatch + "("
                + snmpVersionDesc + ")");
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                "Version : " + receiveSnmpVersionDispatch + " ("
                + snmpVersionDesc + ")");

            if (receiveSnmpVersionDispatch != SnmpPreference.SNMPV3) {
                byte command = receivedMessage.getCommand();
                setCommandLog(command);

                byte[] communityByte = receivedMessage.getCommunity();

                logger.info("Community : " + bytetoChar(communityByte));
                logger.info(
                    "Command : " + hexByte(command) + " ("
                    + snmpCommandCodeDesc + ")");

                AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                    "Community : " + bytetoChar(communityByte));
                AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                    "Command : " + hexByte(command) + " ("
                    + snmpCommandCodeDesc + ")");
            }
        } catch (SnmpBadValueException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw e;
        }

        /*
         * }l[WMSNMP VersionɂďU蕪
         */
        switch (receiveSnmpVersionDispatch) {
        case SnmpPreference.SNMP_VERSION_1:
            mp = new AgentV1MP(dSocket);

            break;

        case SnmpPreference.SNMPV2C:
            mp = new AgentV2MP(dSocket);

            break;

        case SnmpPreference.SNMPV3:
            mp = new AgentV3MP(dSocket);

            break;

        default:
            logger.warning("Undefined command");
        }

        try {
            /*
             * Manager̃R}hMAgent SysUpTimeXV
             */
            AgentSysupTime.getInstance().updateSysupTime();

            /*
             * SNMP AgentƂĎMs
             * (Mf[^͂AM)
             */
            mp.process(inPacket, encodedMessage, receiveLength);
        } catch (SnmpErrorStatusException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            date = Calendar.getInstance().getTime();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                "Receive data error status not correct : "
                + dateformat.format(date));
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                hexBytetoString(encodedMessage, receiveLength));
        } catch (SnmpBadValueException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            date = Calendar.getInstance().getTime();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                "Abort create response data : " + dateformat.format(date));
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                hexBytetoString(encodedMessage, receiveLength));

            throw e1;
        } catch (IOException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
            date = Calendar.getInstance().getTime();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                "Abort send data to " + " : " + dateformat.format(date));
            throw e1;
        }
    }

    /*
     * SNMPR}hMOs܂B
     *
     * @param code SNMPR}hR[h
     */
    private void setCommandLog(byte code) {
        switch (code) {
        case SnmpBERCodec.SNMPGETREQUEST:
            snmpCommandCodeDesc = SnmpBERCodec.COMMAND_GET_REQUEST_DESCRIPTION;

            break;

        case SnmpBERCodec.SNMPGETNEXTREQUEST:
            snmpCommandCodeDesc =
                SnmpBERCodec.COMMAND_GET_NEXT_REQUEST_DESCRIPTION;

            break;

        case SnmpBERCodec.SNMPSETREQUEST:
            snmpCommandCodeDesc = SnmpBERCodec.COMMAND_SET_REQUEST_DESCRIPTION;

            break;

        default:
            snmpCommandCodeDesc = "Unknown";
            logger.warning("Undefined SNMP Command code : " + code);

            return;
        }
    }

    /*
     * SNMPo[WR[ho[WDescriprionZbg܂B
     *
     * @param version SNMPo[WR[h
     */
    private void setSnmpVersion(int version) {
        switch (version) {
        case SnmpPreference.SNMP_VERSION_1:
            snmpVersionDesc = SnmpPreference.SNMPV1_DESCRIPTION;

            break;

        case SnmpPreference.SNMPV2C:
            snmpVersionDesc = SnmpPreference.SNMPV2_DESCRIPTION;

            break;

        case SnmpPreference.SNMPV3:
            snmpVersionDesc = SnmpPreference.SNMPV3_DESCRIPTION;

            break;

        default:
            logger.warning("Bad Snmp version: " + version);

            return;
        }
    }

    /**
     * oCgzf[^𕶎ɕϊĕԂ܂B
     *
     * @param byteData oCgzf[^
     * @param receiveLength f[^
     * @return ϊ
     */
    public String hexBytetoString(byte[] byteData, int receiveLength) {
        StringBuffer returnString = new StringBuffer();

        for (int i = 0; (byteData.length > i) && (receiveLength > i); i++) {
            if (i != 0) {
                if ((i % 16) == 0) {
                    returnString.append(System.getProperty("line.separator"));
                }
            }

            int pos = byteData[i];

            if (pos < 0) {
                pos += 256;
            }

            returnString.append(Integer.toHexString(pos / 16));
            returnString.append((Integer.toHexString(pos % 16) + " "));
        }

        return returnString.toString();
    }

    /**
     * oCgf[^𕶎ɕϊĕԂ܂B
     *
     * @param byteData ɕϊoCgR[h
     * @return ϊ
     */
    public String hexByte(byte byteData) {
        String returnString = "";

        int pos = byteData;

        if (pos < 0) {
            pos += 256;
        }

        returnString += Integer.toHexString(pos / 16);
        returnString += Integer.toHexString(pos % 16);

        return returnString;
    }

    /** oCgzf[^𕶎ɕϊĕԂ܂B
     *
     * @param byteData oCgzf[^
     * @return ϊ
     */
    public String bytetoChar(byte[] byteData) {
        String returnString = "";

        for (int i = 0; i < byteData.length; i++) {
            returnString += (char) byteData[i];
        }

        return returnString;
    }
}
