/*
 * Created on 2004/03/17
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 *
 */
package netjfwatcher.snmpmanager.trap;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.engine.common.model.DataStringDisplay;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;



/**
 * Snmp}l[WłTrapMpXbhVOgNXłB
 * BTrapMXbhƂāAVOgNX܂B
 *
 * ۂTrapḾATrapDispatcherŏ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ThreadTrapReceive extends DataStringDisplay implements Runnable {
    /* Tread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger;

    /*
     * TrapMf[^OSocketiMJnThreadŐj
     */
    private DatagramSocket dSocket;

    /* TrapM|[gԍi\[XǂݏolRX
     * gN^ŃZbgj
     */
    private final int trapPort;

    /* TrapMThread */
    private Thread trapReceiveThread;

    /* Xi[o^郊Xg */
    private final List<ITrapListener> listenerList =
        Collections.synchronizedList(new ArrayList<ITrapListener>());

    /**
     * TRAPMpSocket𐶐AThread𐶐܂B<BR>
     *
     */
    private ThreadTrapReceive() {
        logger = Logger.getLogger(this.getClass().getName());

        /* TrapM|[gԍ\[Xǂݏo */
        trapPort =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpTrapPort();
    }

    /**
     * TrapXi[Xgɓo^܂B
     * TrapMThreadNꂽɃXi[Xgɓo^܂B
     *
     * @param listener TrapMXi[
     */
    public void addTrapListener(final ITrapListener listener) {
        /* Xi[ɃXgɓo^ĂΉɃ^[ */

        // see if listener already added; if so, ignore
        for (int i = 0; i < listenerList.size(); i++) {
            if (listener == listenerList.get(i)) {
                return;
            }
        }

        // if got here, it's not in the list; add it
        listenerList.add(listener);
    }

    /**
     * TrapXi[Xg폜܂B
     *
     * @param listener TrapMXi[
     */
    public void removeTrapListener(final ITrapListener listener) {
        // see if listener in list; if so, remove, if not, ignore
        for (int i = 0; i < listenerList.size(); i++) {
            if (listener == listenerList.get(i)) {
                listenerList.remove(i);

                break;
            }
        }
    }

    /**
     * Trap receive thread̏ԂԂ܂B
     *
     * @return Trap receive thread
     * true :ThreadN
     * false:Thread~
     */
    public boolean checkThread() {
        if ((trapReceiveThread == null) || !trapReceiveThread.isAlive()) {
            return false;
        }

        return true;
    }

    /**
     * TrapMThread̋NԂԂƂƂɁAN̏ꍇTrapM
     * ThreadX^[g܂B
     *
     * @return ThreadN boolean
     * true :ThreadN
     * false:ThreadNs
     */
    public boolean startReceiving() {
        // TrapMXbhN̏ꍇɋN
        if ((trapReceiveThread == null) || !trapReceiveThread.isAlive()) {
            try {
                dSocket = new DatagramSocket(trapPort);
                trapReceiveThread = new Thread(this);
            } catch (SocketException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
                logger.warning("Trap thread start abort : " + e.getMessage());

                return false;
            }

            if (trapReceiveThread != null) {
                trapReceiveThread.start();
            }

            logger.info("Trap thread start successful");

            return true;
        }

        logger.warning(
            "Trap thread start abort : trapReceiveThread = "
            + trapReceiveThread + "  trapReceiveThread isAlive = "
            + trapReceiveThread.isAlive());

        return false;
    }

    /**
     * TrapMXbh~܂B
     *
     */
    public void stopReceiving() {
        if (trapReceiveThread == null) {
            return;
        }

        // interrupt receive thread so it will die a natural death
        trapReceiveThread.interrupt();

        if (dSocket != null) {
            dSocket.close();

            /* TrapMThread~܂Loop */
            while ((trapReceiveThread != null) && trapReceiveThread.isAlive()) {
                try {
                    Thread.sleep(WAIT_SLEEP_TIME);
                } catch (InterruptedException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }

            dSocket = null;
        }

        logger.info("Trap thread stop");
        trapReceiveThread = null;
    }

    /**
     * TrapM҂XbhłB
     * ۂTrapMSNMP VersioñfBXpb`[ōs܂
     *
     */
    public void run() {
        logger.info("Trap receive start");

        /*
         * TrapM҂yуfBXpb`[(U蕪)
         * [vɂTrapMɐVɐEN
         */
        while (
            (trapReceiveThread != null) && !trapReceiveThread.isInterrupted()) {
            /*
             * TrapM҂(Trap SNMP VersionɑΉւ
             * fBXpb`[(U蕪))N
             */
            TrapDispatcher dispPatcher = new TrapDispatcher();

            try {
                dispPatcher.disptcher(dSocket, listenerList);
            } catch (SocketException e) {
                if (dSocket.isClosed()) {
                    /* Thread stopwɂꍇɂُ͈ƂȂ */
                    logger.info(
                        "Trap Receive Socket closed : " + e.getMessage());
                } else {
                    logger.warning("Trap receive error : " + e.getMessage());
                    e.printStackTrace();
                }
            } catch (GeneralSecurityException e) {
                logger.warning("Trap receive error : " + e.getMessage());
                e.printStackTrace();
            } catch (SnmpV3ConfigurationException e) {
                logger.warning("Trap receive error : " + e.getMessage());
                e.printStackTrace();
            } catch (SnmpBadValueException e) {
                logger.warning("Trap receive error : " + e.getMessage());
                e.printStackTrace();
            } catch (SnmpV3DecryptAbortException e) {
                logger.warning("Trap receive error : " + e.getMessage());
                e.printStackTrace();
            } catch (IOException e) {
                logger.warning("Trap receive error : " + e.getMessage());
                e.printStackTrace();
            }
        }

        logger.info("Trap receive thread interrupted");
    }

    /**
     * DatagramSocketclose܂B
     *
     * @see java.lang.Object#finalize()
     */
    protected void finalize() throws Throwable {
        super.finalize();

        if (dSocket != null) {
            dSocket.close();
        }
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ThreadTrapReceive getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final ThreadTrapReceive RESOURCE = new ThreadTrapReceive();
    }
}
