/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.trap;

import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;



/**
 * SNMP V2 TrapM\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class TrapV2ReceiveMP extends AbstractTrapMessageProcessing {
    /* MO */
    private Logger logger;

    /**
     * Snmp V2 TrapMCX^X𐶐܂B
     *
     */
    public TrapV2ReceiveMP() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * Snmp TrapMłdisptcherSnmp V2̏ꍇɋNA
         * Mf[^͂ATrapMXi[o^ꂢ郊Xg
         * Xi[ǂݏoAtrapMƂẴe[u\Ȃǂs܂B
         *
     * Snmp V2cyV3 TrapMs܂B
     *
     * @param agentAddress AgentAhX
     * @param encodedMessage Mf[^
     * @param listenerList TrapMXi[Xg
     * @throws SnmpBadValueException TrapMf[^ُŉ͂Ɏsꍇ
     */
    public final void process(
        final String agentAddress, final byte[] encodedMessage,
        final List listenerList) throws SnmpBadValueException {
        /* SNMP V2 TrapbZ[WpPbg̃fR[h */
        SnmpSequence receiveSnmpSequence = new SnmpSequence();
        SNMPTLV nextTLV3 =
            receiveSnmpSequence.extractNextTLV(encodedMessage, 0);

        try {
            receiveSnmpSequence.setTLV(nextTLV3);
        } catch (SnmpBadValueException e) {
            logger.warning("Trap V2 parse error : " + e.getMessage());
            e.printStackTrace();
            throw e;
        }

        /* SNMP̃o[WoE`FbN */
        AbstractSnmpObject msgVersion2 = receiveSnmpSequence.getSNMPObjectAt(0);

        if (!(msgVersion2 instanceof SnmpInteger)) {
            logger.warning("SNMP V2 Trap Version is not INTEGER");
            throw new SnmpBadValueException(
                "Version is not INTEGER : " + msgVersion2.toString());
        }

        /* SnmpOctetString community =
            (SnmpOctetString) receiveSnmpSequence.getSNMPObjectAt(1);
        System.out.println("version : " + msgVersion2.getValue());
        System.out.println("community : " + community);
        */

        SnmpTrap2PDU trap2PDU =
            this.parseSNMPTrap2PDU(receiveSnmpSequence.getSNMPObjectAt(2));


        /*
         * TrapMXi[o^Ă郊Xg烊Xi[ǂݏo
         *
         */
        for (int i = 0; i < listenerList.size(); i++) {
            /* Xi[ɎĂTrapMs */
            ITrapListener listener = (ITrapListener) listenerList.get(i);

            listener.processTrapV2(
            		 trap2PDU, SnmpPreference.SNMPV2_DESCRIPTION, agentAddress);
        }
    }
}
