/*
 * Created on 2005/04/14
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.nodetree;

import netjfwatcher.common.view.INodeTreeNode;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;



/**
 * m[hTree View ContentProviderNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeTreeViewContentProvider implements ITreeContentProvider {
    /**
     * qm[hԂ܂B
     *
     * @param parentElement Object
     * @return qm[h
     */
    public Object[] getChildren(Object parentElement) {
        INodeTreeNode node = (INodeTreeNode) parentElement;

        return node.getChildren();
    }

    /**
     * GgԂ܂B
     *
     * @param inputElement Object
     * @return  Object[]
     */
    public Object[] getElements(Object inputElement) {
        return getChildren(inputElement);
    }

    /**
     * em[hԂ܂B
     *
     * @param element Object
     * @return em[h
     */
    public Object getParent(Object element) {
        INodeTreeNode node = (INodeTreeNode) element;

        return node.getParent();
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.IContentProvider#dispose()
     */
    public void dispose() {
        // nothing
    }

    /**
     * qm[h݂邩Ԃ܂B
     *
     * @param element Object
     * @return qm[h݂邩tO
     */
    public boolean hasChildren(Object element) {
        INodeTreeNode node = (INodeTreeNode) element;

        return node.hasChildren();
    }

    /*
     *  (non-Javadoc)
     * @see org.eclipse.jface.viewers.
     * IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
     * java.lang.Object, java.lang.Object)
     */
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        // if (log.isDebugEnabled()) {
        //    log.debug(oldInput + " => " + newInput);
        // }
    }
}
