/*
 * Created on 2006/12/02
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netwatcher.networkcamera.gui.editor;

import netwatcher.networkcamera.model.HttpAccess;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorSite;

public class EditorCameraTimerProcessor implements Runnable {

	public static final int TIMER = 1000;

	public static final int TIMER_STOP = -1;
	
	private Display display;

	private IEditorSite editorSite;

	private String targetURL;

	private Label imageLabel;
	
	private String ipAddress;
	private int timer;
	private HttpAccess httpAccess;
	private int httpTimeout = 0;
	private String userName;
	private String password;
	
	public EditorCameraTimerProcessor() {
		timer = TIMER;
		httpAccess = new HttpAccess();
	}

	public void run() {
		if (editorSite.getPage().isPartVisible(editorSite.getPart())) {
			Image cameraImage = null;
			
			try {
				cameraImage = httpAccess.getURLImage(ipAddress, targetURL, display,
						httpTimeout, userName, password);
				if (cameraImage != null) {
					imageLabel.setImage(cameraImage);
				}
			} catch (Exception e) {
				MessageDialog.openError(editorSite.getShell(), "Error", "Abort get Network Camera Image " + e.getMessage());

			}			
			

		}
		// ^C}[p
		display.timerExec(timer, this);
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static EditorCameraTimerProcessor getInstance() {
		return SingletonResource.TIMER_POCESSOR;
	}


	public void setDisplay(Display display, IEditorSite editorSite, Label imageLabel) {
		
		this.display = display;
		this.editorSite = editorSite;
		this.imageLabel = imageLabel;
	}


	public void setTargetURL(String ipAddress, String targetURL, int timer, String userName, String password) {
		this.ipAddress = ipAddress;
		this.targetURL = targetURL;
		this.timer = timer;
		this.userName = userName;
		this.password = password;
	}
	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final EditorCameraTimerProcessor TIMER_POCESSOR = new EditorCameraTimerProcessor();
	}
}
