/*
 * Created on 2007/03/12
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.nodemap.gui.icon;

import java.util.logging.Logger;

import netjfwatcher.engine.nodemaneger.map.NodeMapInfo;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;

public class NodeIconViewDraw {
	/* zFColor` */
	private static Color WHITE_COLOR;

	private static Color BLACK_COLOR;

	private static Color RED_COLOR;

	private static Color TEST_COLOR;

	/* m[hMap Canvas */
	private Canvas canvas;

	/* GC */
	private GC gc;

	private static Logger logger;

	/**
	 * m[hMap View`NXCX^X𐶐܂B
	 * 
	 * @param canvas
	 *            Canvas
	 * @param gc
	 *            GC
	 */
	public NodeIconViewDraw(Canvas canvas, GC gc) {
		logger = Logger.getLogger(this.getClass().getName());

		this.canvas = canvas;
		this.gc = gc;

		WHITE_COLOR = new Color(null, 255, 255, 255);
		BLACK_COLOR = new Color(null, 0, 0, 0);
		RED_COLOR = new Color(null, 255, 0, 0);
		TEST_COLOR = new Color(null, 127, 127, 127);
	}

	/**
	 * m[hLinkyуm[hĕ`悵܂B
	 * 
	 * @param nodeMapNodeInfoList
	 *            m[hIcon񃊃Xg
	 * @param nodMapLinkInformationList
	 *            m[hN
	 */
	public void redraw(NodeMapInfo nodeMapinfo) {

		gc.fillRectangle(canvas.getClientArea());

		int height = canvas.getClientArea().height - 1;
		int width = canvas.getClientArea().width - 1;
		gc.setForeground(TEST_COLOR);
		gc.drawLine(0, 0, width, 0);
		gc.drawLine(0, 0, 0, height);
		gc.setForeground(WHITE_COLOR);
		gc.drawLine(width, 0, width, height);
		gc.drawLine(0, height, width, height);
		gc.setBackground(WHITE_COLOR);
		gc.setForeground(BLACK_COLOR);

		/* m[h` */
		drawNode(nodeMapinfo);

		gc.drawRectangle(0, 0, NodeIconView.NODE_ICON_X
				+ nodeMapinfo.getWidth() + NodeIconView.NODE_ICON_X,
				NodeIconView.NODE_ICON_Y + nodeMapinfo.getHeight()
						+ NodeIconView.NODE_ICON_Y);
	}

	/**
	 * m[h`悵܂B
	 * 
	 * @param nodeMapNodeInfoList
	 *            m[hIcon񃊃Xg
	 */
	protected void drawNode(NodeMapInfo nodeMapinfo) {
		setColor();

		gc.setForeground(BLACK_COLOR);

		if (!nodeMapinfo.isSelected()) {
			gc.drawImage(nodeMapinfo.getNodeIconImage(), nodeMapinfo.getX(),
					nodeMapinfo.getY());

		} else {
			gc.drawImage(nodeMapinfo.getNodeIconImage(), nodeMapinfo.getX(),
					nodeMapinfo.getY());
			gc.drawOval(nodeMapinfo.getX(), nodeMapinfo.getY(), nodeMapinfo
					.getWidth(), nodeMapinfo.getHeight());
		}

	}

	/*
	 * ColorIuWFNgZbg܂B
	 * 
	 */
	private void setColor() {
		/*
		 * ColorIuWFNgjĂ΍ăZbg
		 */
		if ((WHITE_COLOR == null) || WHITE_COLOR.isDisposed()) {
			WHITE_COLOR = new Color(null, 255, 255, 255);
		}

		if ((BLACK_COLOR == null) || BLACK_COLOR.isDisposed()) {
			BLACK_COLOR = new Color(null, 0, 0, 0);
		}

		if ((RED_COLOR == null) || RED_COLOR.isDisposed()) {
			RED_COLOR = new Color(null, 255, 0, 0);
		}

		if ((TEST_COLOR == null) || TEST_COLOR.isDisposed()) {
			TEST_COLOR = new Color(null, 127, 127, 127);
		}
	}

}
