/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.table.plainlog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import netjfwatcher.webalizer.model.info.AccessPlainLogInfo;

public final class AccessLogInfoReceiveMessageQueue {
	/* L[郊Xg */
	private static List<AccessPlainLogInfo> accessLogInfoQueueList;

	private static final int LIMIT = 100000;

	private AccessLogInfoReceiveMessageQueue() {
		accessLogInfoQueueList = Collections
				.synchronizedList(new ArrayList<AccessPlainLogInfo>());
	}

	public synchronized void clearMessageQueue() {
		accessLogInfoQueueList.clear();
	}

	public synchronized void pushAccessLogInfo(
			final AccessPlainLogInfo accessLogInfo) {

		if (accessLogInfoQueueList.size() > LIMIT) {
			accessLogInfoQueueList.remove(0);
			accessLogInfoQueueList.add(accessLogInfo);
		} else {
			accessLogInfoQueueList.add(accessLogInfo);
		}
	}

	public synchronized AccessPlainLogInfo popAccessLogInfo() {
		AccessPlainLogInfo accessLogInfo = null;

		if (accessLogInfoQueueList.size() > 0) {
			accessLogInfo = (AccessPlainLogInfo) accessLogInfoQueueList.get(0);
			accessLogInfoQueueList.remove(0);
		}

		return accessLogInfo;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static AccessLogInfoReceiveMessageQueue getInstance() {
		return SingletonResource.BEAN_MESSAGE_QUEUE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final AccessLogInfoReceiveMessageQueue BEAN_MESSAGE_QUEUE = new AccessLogInfoReceiveMessageQueue();
	}

}
