/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.table.plainlog;

import netjfwatcher.webalizer.gui.filtersearch.LogDataFilterInfo;
import netjfwatcher.webalizer.model.ClientDomain;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class AccessLogTableListener extends SelectionAdapter {

	private final Table accessLogTable;

	public AccessLogTableListener(Table table) {
		this.accessLogTable = table;
	}

	/**
	 * TableIłB
	 * 
	 * @param event
	 *            SelectionEvent
	 */
	public void widgetSelected(SelectionEvent event) {
		/* e[uIs(Row)o */
		int index = accessLogTable.getSelectionIndex();

		if (index == -1) {
			return;
		}

		if (!LogDataFilterInfo.getInstance().isSearchDomain()) {
			return;
		}
		// TablȇI͈͂
		// table.setSelection(new int[0]);
		// Iꂽs(Row)TableItem擾
		TableItem item = accessLogTable.getItem(index);

		String ipAddress = item
				.getText(AccessLogTableViewLabelProvider.IP_ADDRESS_COLUMN_NO);
		String domainName = ClientDomain.getInstance().getDomain(ipAddress);

		item.setText(AccessLogTableViewLabelProvider.DOMAIN_COLUMN_NO,
				domainName);

	}

}
