/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.table.plainlog;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.webalizer.gui.action.ActionBuilderAccessLogTable;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

public class AccessLogTableView extends AbstractTableView {

	private static boolean isCol0Direction = false;

	private static boolean isCol1Direction = true;

	private static boolean isCol2Direction = true;

	private static boolean isCol3Direction = true;

	private static boolean isCol4Direction = true;

	private static boolean isCol5Direction = true;

	private static boolean isCol6Direction = true;

	private static boolean isCol7Direction = true;

	private static boolean isCol8Direction = true;

	private static boolean isCol9Direction = true;

	private static boolean isCol10Direction = true;

	private TableColumn col0;

	private TableColumn col1;

	private TableColumn col2;

	private TableColumn col3;

	private TableColumn col4;

	private TableColumn col5;

	private TableColumn col6;

	private TableColumn col7;

	private TableColumn col8;

	private TableColumn col9;

	private TableColumn col10;

	/* J */
	private static final float COLUMN0_NO = 0.04f;

	private static final float COLUMN1_IP = 0.2f;

	private static final float COLUMN2_DOMAIN = 0.1f;

	private static final float COLUMN3_USER_NAME = 0.02f;

	private static final float COLUMN4_AUTH_USER = 0.02f;

	private static final float COLUMN5_DATE = 0.15f;

	private static final float COLUMN6_REQUEST = 0.15f;

	private static final float COLUMN7_STATUS = 0.03f;

	private static final float COLUMN8_BYTE = 0.04f;

	private static final float COLUMN9_REFERER = 0.1f;

	private static final float COLUMN10_AGENT = 0.1f;

	/* Table */
	private Table table;

	/* TableViewer */
	private TableViewer viewer;

	private AccessLogTableTimerProcessor timerProcessor;

	private ActionBuilderAccessLogTable actionAccessLogTableBuilder;

	private ActionBuilderEditorsPartClose actionEditorsPartClose;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	/**
	 * Snmp ManagerƂAgent̉SnmpCX^Xf[^e[u \NXCX^X𐶐܂B
	 * 
	 */
	public AccessLogTableView() {
		// nothing
	}

	/**
	 * ActionBuilderԂ܂B
	 * 
	 * @return actionBuilder actionOidTableBuilder
	 */
	private ActionBuilderAccessLogTable getActionBuilder() {
		return actionAccessLogTableBuilder;
	}

	/**
	 * tH[JXZbgꂽƂ̏łB
	 */
	public void setFocus() {

	}

	/**
	 * e[uViewi\`̌ځjԂ܂B
	 * 
	 * @return viewer TableViewer
	 */
	public TableViewer getViewer() {
		return viewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		display = parent.getDisplay();
		createTable(parent);
		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		viewer.setContentProvider(new AccessLogTableViewContentProvider());

		/* xEtHgȂǂݒ */
		viewer.setLabelProvider(new AccessLogTableViewLabelProvider());

		actionAccessLogTableBuilder = new ActionBuilderAccessLogTable(table);
		actionEditorsPartClose = new ActionBuilderEditorsPartClose();
		createContextMenu();
		initActions();
		AccessLogTableTimerProcessor.getInstance().setTable(viewer, table);

		startTimer();

		/*
		 * table.addSelectionListener(new TableColumnControlTableListener(table,
		 * AccessLogTableViewLabelProvider.REQUEST_COLUMN_NO));
		 * table.addSelectionListener(new TableColumnControlTableListener(table,
		 * AccessLogTableViewLabelProvider.REFERER_COLUMN_NO));
		 */
	}

	private void startTimer() {

		AccessLogTableTimerProcessor.getInstance().setDisplay(display,
				statusLineManager);
		timerProcessor = AccessLogTableTimerProcessor.getInstance();
		display.timerExec(AccessLogTableTimerProcessor.TIMER, timerProcessor);

	}

	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0_NO);
	}

	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1_IP);
	}

	private int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN2_DOMAIN);
	}

	private int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN3_USER_NAME);
	}

	private int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN4_AUTH_USER);
	}

	private int computeCol5Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN5_DATE);
	}

	private int computeCol6Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN6_REQUEST);
	}

	private int computeCol7Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN7_STATUS);
	}

	private int computeCol8Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN8_BYTE);
	}

	private int computeCol9Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN9_REFERER);
	}

	private int computeCol10Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN10_AGENT);
	}

	/**
	 * e[u𐶐܂B e[ůeJwb_[̃^CgAJZbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	private void createTable(Composite parent) {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);

		table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);

		col0 = new TableColumn(table, SWT.LEFT);
		col0
				.setText(AccessLogTableViewLabelProvider.HEADER_COLUMNS[AccessLogTableViewLabelProvider.NO_COLUMN_NO]);
		col0.setWidth(computeCol0Width());

		col1 = new TableColumn(table, SWT.LEFT);
		col1
				.setText(AccessLogTableViewLabelProvider.HEADER_COLUMNS[AccessLogTableViewLabelProvider.IP_ADDRESS_COLUMN_NO]);
		col1.setWidth(computeCol1Width());

		col2 = new TableColumn(table, SWT.LEFT);
		col2
				.setText(AccessLogTableViewLabelProvider.HEADER_COLUMNS[AccessLogTableViewLabelProvider.DOMAIN_COLUMN_NO]);
		col2.setWidth(computeCol2Width());

		col3 = new TableColumn(table, SWT.LEFT);
		col3
				.setText(AccessLogTableViewLabelProvider.HEADER_COLUMNS[AccessLogTableViewLabelProvider.USER_NAME_COLUMN_NO]);
		col3.setWidth(computeCol3Width());

		col4 = new TableColumn(table, SWT.LEFT);
		col4
				.setText(AccessLogTableViewLabelProvider.HEADER_COLUMNS[AccessLogTableViewLabelProvider.AUTH_USER_NAME_COLUMN_NO]);
		col4.setWidth(computeCol4Width());

		col5 = new TableColumn(table, SWT.LEFT);
		col5
				.setText(AccessLogTableViewLabelProvider.HEADER_COLUMNS[AccessLogTableViewLabelProvider.DATE_COLUMN_NO]);
		col5.setWidth(computeCol5Width());

		col6 = new TableColumn(table, SWT.LEFT);
		col6
				.setText(AccessLogTableViewLabelProvider.HEADER_COLUMNS[AccessLogTableViewLabelProvider.REQUEST_COLUMN_NO]);
		col6.setWidth(computeCol6Width());

		col7 = new TableColumn(table, SWT.LEFT);
		col7
				.setText(AccessLogTableViewLabelProvider.HEADER_COLUMNS[AccessLogTableViewLabelProvider.STATUS_COLUMN_NO]);
		col7.setWidth(computeCol7Width());

		col8 = new TableColumn(table, SWT.LEFT);
		col8
				.setText(AccessLogTableViewLabelProvider.HEADER_COLUMNS[AccessLogTableViewLabelProvider.BYTES_COLUMN_NO]);
		col8.setWidth(computeCol8Width());

		col9 = new TableColumn(table, SWT.LEFT);
		col9
				.setText(AccessLogTableViewLabelProvider.HEADER_COLUMNS[AccessLogTableViewLabelProvider.REFERER_COLUMN_NO]);
		col9.setWidth(computeCol9Width());

		col10 = new TableColumn(table, SWT.LEFT);
		col10
				.setText(AccessLogTableViewLabelProvider.HEADER_COLUMNS[AccessLogTableViewLabelProvider.AGENT_COLUMN_NO]);
		col10.setWidth(computeCol10Width());

		/*
		 * TableōsNbNꂽꍇ̏
		 */
		table.addSelectionListener(new AccessLogTableListener(table));

		/**
		 * e[uړꍇ͂TCYꍇ̃Xi[łB
		 * 
		 */
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
				.addControlListener(new ControlListener() {
					public void controlMoved(ControlEvent event) {
					}

					/*
					 * e[uTCYɃe[uJZbg܂B
					 */
					public void controlResized(ControlEvent event) {
						/*
						 * OIDe[u\Ԃł΃e[uJZbg
						 */
						setResizedTableColumnWidth();
					}
				});

		col0.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol0Direction = sortIntegerTable(table,
						AccessLogTableViewLabelProvider.NO_COLUMN_NO,
						isCol0Direction);
			}
		});

		col1.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol1Direction = sortTable(table,
						AccessLogTableViewLabelProvider.IP_ADDRESS_COLUMN_NO,
						isCol1Direction);
			}
		});

		col2.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				/*
				 * isCol2Direction = sortTable(table,
				 * AccessLogTableViewLabelProvider.DOMAIN_COLUMN_NO,
				 * isCol2Direction);
				 */
			}
		});

		col3.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				/*
				 * isCol3Direction = sortTable(table,
				 * AccessLogTableViewLabelProvider.USER_NAME_COLUMN_NO,
				 * isCol3Direction);
				 */
			}
		});

		col4.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				/*
				 * isCol4Direction = sortTable(table,
				 * AccessLogTableViewLabelProvider.AUTH_USER_NAME_COLUMN_NO,
				 * isCol4Direction);
				 */
			}
		});

		col5.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				/*
				 * isCol5Direction = sortTable(table,
				 * AccessLogTableViewLabelProvider.DATE_COLUMN_NO,
				 * isCol5Direction);
				 */
			}
		});

		col6.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				/*
				 * isCol6Direction = sortTable(table,
				 * AccessLogTableViewLabelProvider.REQUEST_COLUMN_NO,
				 * isCol6Direction);
				 */
			}
		});

		col7.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol7Direction = sortTable(table,
						AccessLogTableViewLabelProvider.STATUS_COLUMN_NO,
						isCol7Direction);
			}
		});

		col8.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol8Direction = sortIntegerTable(table,
						AccessLogTableViewLabelProvider.BYTES_COLUMN_NO,
						isCol8Direction);
			}
		});

		col9.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				/*
				 * isCol9Direction = sortTable(table,
				 * AccessLogTableViewLabelProvider.REFERER_COLUMN_NO,
				 * isCol9Direction);
				 */
			}
		});

		col10.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				/*
				 * isCol10Direction = sortTable(table,
				 * AccessLogTableViewLabelProvider.AGENT_COLUMN_NO,
				 * isCol10Direction);
				 */
			}
		});
	}

	protected void setResizedTableColumnWidth() {
		/*
		 * e[u\Ԃł΃e[uJZbg
		 */
		if (getSite().getPage().isPartVisible(getSite().getPart())
				&& getSite().getShell() != null) {
			if (getSite().getShell().getSize() != null) {
				col0.setWidth(computeCol0Width());
				col1.setWidth(computeCol1Width());
				col2.setWidth(computeCol2Width());
				col3.setWidth(computeCol3Width());
				col4.setWidth(computeCol4Width());
				col5.setWidth(computeCol5Width());
				col6.setWidth(computeCol6Width());
				col7.setWidth(computeCol7Width());
				col8.setWidth(computeCol8Width());
				col9.setWidth(computeCol9Width());
				col10.setWidth(computeCol10Width());
			}
		}

	}

	/**
	 * j[o[ preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		/* j[}l[WɃANVZbg */
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		manager.add(getActionBuilder().actionAnalysis());
		manager.add(getActionBuilder().actionClearTable());
		manager.add(actionEditorsPartClose.actionCloseAllEditors());
	}

	/**
	 * ContextMenu𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[}l[WXi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			/**
			 * j[}l[WXi[łB
			 */
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/*
		 * ReLXgj[𐶐Zbg
		 */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	private void initActions() {
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();
		toolBarManager.add(getActionBuilder().actionAnalysis());
		toolBarManager.add(getActionBuilder().actionClearTable());
		toolBarManager.add(actionEditorsPartClose.actionCloseAllEditors());
	}

}
