/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.table.sitelog;

import netjfwatcher.webalizer.gui.filtersearch.LogDataFilterInfo;
import netjfwatcher.webalizer.model.ClientDomain;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class LogAlizerTableListener extends SelectionAdapter {

	private final Table managerOidTable;


	public LogAlizerTableListener(Table table) {
		this.managerOidTable = table;
	}

	/**
	 * TableIłB
	 * 
	 * @param event
	 *            SelectionEvent
	 */
	public void widgetSelected(SelectionEvent event) {
		/* e[uIs(Row)o */
		int index = managerOidTable.getSelectionIndex();

		if (index == -1) {
			return;
		}

		if (!LogDataFilterInfo.getInstance().isSearchDomain()) {
			return;
		}
		// TablȇI͈͂
		// table.setSelection(new int[0]);
		// Iꂽs(Row)TableItem擾
		TableItem item = managerOidTable.getItem(index);

		String ipAddress = item
				.getText(LogAlizerTableViewLabelProvider.HOST_NAME_COLUMN_NO);
		String domainName = ClientDomain.getInstance().getDomain(ipAddress);

		item.setText(LogAlizerTableViewLabelProvider.DOMAIN_COLUMN_NO,
				domainName);

	}

}
