/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.table.sitelog;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.webalizer.gui.filtersearch.LogDataFilterInfo;
import netjfwatcher.webalizer.model.info.AccessSiteLogInfo;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class LogAlizerTableTimerProcessor extends AbstractTableView implements
		Runnable {

	public static final int TIMER = 1000;

	private Display display;

	private TableViewer viewer;

	private Table accessLogTable;

	private SubStatusLineManager statusLineManager;

	private DateFormat dateformat;

	private LogAlizerTableTimerProcessor() {
		dateformat = new SimpleDateFormat("yyyy-MM-dd(E) HH:mm:ss");
	}

	public void run() {

		if (accessLogTable != null && !accessLogTable.isDisposed()
				&& accessLogTable.getVisible()) {

			AccessSiteLogInfo accessLogInfo = (AccessSiteLogInfo) LogAlizerInfoReceiveMessageQueue
					.getInstance().popAccessLogInfo();

			while (accessLogInfo != null) {

				String[] logInfo = new String[LogAlizerTableViewLabelProvider.MANAGER_TABLE_ARRAY_COUNT];

				logInfo[LogAlizerTableViewLabelProvider.NO_COLUMN_NO] = accessLogInfo
						.getLogNo();
				logInfo[LogAlizerTableViewLabelProvider.HOST_NAME_COLUMN_NO] = accessLogInfo
						.getAccessIPAddress();
				logInfo[LogAlizerTableViewLabelProvider.DOMAIN_COLUMN_NO] = accessLogInfo
						.getDomainName();
				logInfo[LogAlizerTableViewLabelProvider.HITS_COLUMN_NO] = accessLogInfo
						.getHitCount();
				logInfo[LogAlizerTableViewLabelProvider.FILES_COLUMN_NO] = accessLogInfo
						.getFileCount();

				logInfo[LogAlizerTableViewLabelProvider.PAGES_COLUMN_NO] = accessLogInfo
						.getPageCount();

				logInfo[LogAlizerTableViewLabelProvider.VISITS_COLUMN_NO] = accessLogInfo
						.getVisitCount();
				logInfo[LogAlizerTableViewLabelProvider.BYTES_COLUMN_NO] = accessLogInfo
						.getByteCount();

				TableItem tableItem = new TableItem(accessLogTable, SWT.NULL);
				tableItem.setData(logInfo);
				tableItem.setText(logInfo);

				accessLogInfo = (AccessSiteLogInfo) LogAlizerInfoReceiveMessageQueue
						.getInstance().popAccessLogInfo();
				if (accessLogInfo == null) {
					// sortIntegerTable(accessLogTable, 0, true);
				}
				setStatusManager();
			}

		}
		// ^C}[p
		display.timerExec(TIMER, this);
	}

	private void setStatusManager() {
		Date startDate = LogDataFilterInfo.getInstance().getStartDate();
		Date endDate = LogDataFilterInfo.getInstance().getEndDate();
		if (startDate != null && endDate != null) {
			statusLineManager.setMessage("Table count="
					+ accessLogTable.getItemCount() + "    ("
					+ dateformat.format(startDate) + "-"
					+ dateformat.format(endDate) + ")");
		} else {
			statusLineManager.setMessage("Table count="
					+ accessLogTable.getItemCount());
		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static LogAlizerTableTimerProcessor getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * TimersDisplayZbg܂B
	 * 
	 * @param display
	 *            TimersDisplay
	 */
	public void setDisplay(Display display,
			SubStatusLineManager statusLineManager) {
		this.display = display;
		this.statusLineManager = statusLineManager;
	}

	/**
	 * XVe[uZbg܂B
	 * 
	 * @param table
	 *            XVe[u
	 */
	public void setTable(TableViewer viewer, Table table) {
		this.accessLogTable = table;
		this.viewer = viewer;
	}

	protected void setResizedTableColumnWidth() {
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final LogAlizerTableTimerProcessor RESOURCE = new LogAlizerTableTimerProcessor();
	}

	public Table getAccessLogTable() {
		return accessLogTable;
	}

	public TableViewer getViewer() {
		return viewer;
	}
}
