/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.treenode;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class LogNodeTreeGroup extends AbstractLogTreeNode {
	/*
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 1L;

	/*
	 * m[hTree groupɏm[hTreẽm[hi[HashSet
	 */
	private Set<ILogTreeNode> childrenHashSet = new HashSet<ILogTreeNode>();

	/**
	 * m[hTreeɂm[hO[vƂȂTreem[hNX CX^X𐶐܂B
	 * 
	 */
	public LogNodeTreeGroup() {
	}

	/**
	 * m[hTreeɂm[hO[vƂȂTreem[hNX CX^XO[vw肵Đ܂B
	 * 
	 * @param name
	 *            m[hO[v
	 */
	public LogNodeTreeGroup(String name) {
		setName(name);
	}

	/**
	 * m[hTree groupɏm[hTreẽm[hzŕԂ܂B
	 * 
	 * @return INodeTreeNode[]
	 */
	public ILogTreeNode[] getChildren() {
		return (ILogTreeNode[]) childrenHashSet
				.toArray(new ILogTreeNode[childrenHashSet.size()]);
	}

	/**
	 * m[hTree groupIconC[WԂ܂B
	 * 
	 * @return m[hTree groupIconC[W
	 */
	public Image getImage() {
		return PlatformUI.getWorkbench().getSharedImages().getImage(
				ISharedImages.IMG_OBJ_FOLDER);
	}

	/**
	 * m[hTree groupɃm[hTreẽm[ho^܂B
	 * 
	 * @param toAdd
	 *            o^m[hTreẽm[h
	 */
	public void addChild(ILogTreeNode toAdd) {
		childrenHashSet.add(toAdd);
		toAdd.setParent(this);
	}

	/**
	 * Childem[h݂邩Ԃ܂B
	 * 
	 * @return Childem[hݗL
	 */
	public boolean hasChildren() {
		return !childrenHashSet.isEmpty();
	}

	/**
	 * m[hTree groupɏw̃m[hTreẽm[h 폜܂B
	 * 
	 * @param toRemove
	 *            폜m[hTreẽm[h
	 */
	public void removeChild(ILogTreeNode toRemove) {
		childrenHashSet.remove(toRemove);
	}

	/**
	 * SĂChildem[h폜܂B
	 * 
	 */
	public void removeChildAll() {
		childrenHashSet.clear();
	}
}
