/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.model;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;

import netjfwatcher.webalizer.gui.filtersearch.LogDataFilterInfo;

public class CalendarControl {

	private static final String JANUARY = "Jan";

	private static final String FEBRUARY = "Feb";

	private static final String MARCH = "Mar";

	private static final String APRIL = "Apr";

	private static final String MAY = "May";

	private static final String JUNE = "Jun";

	private static final String JULY = "Jul";

	private static final String AUGUST = "Aug";

	private static final String SEPTEMBER = "Sep";

	private static final String OCTBER = "Oct";

	private static final String NOVEMBER = "Nov";

	private static final String DECEMBER = "Dec";

	private CalendarControl() {

	}

	public int getMonthData(String accessMonth) {
		int month = 0;
		if (accessMonth.equals(JANUARY)) {
			month = 0;
		} else if (accessMonth.equals(FEBRUARY)) {
			month = 1;
		} else if (accessMonth.equals(MARCH)) {
			month = 2;
		} else if (accessMonth.equals(APRIL)) {
			month = 3;
		} else if (accessMonth.equals(MAY)) {
			month = 4;
		} else if (accessMonth.equals(JUNE)) {
			month = 5;
		} else if (accessMonth.equals(JULY)) {
			month = 6;
		} else if (accessMonth.equals(AUGUST)) {
			month = 7;
		} else if (accessMonth.equals(SEPTEMBER)) {
			month = 8;
		} else if (accessMonth.equals(OCTBER)) {
			month = 9;
		} else if (accessMonth.equals(NOVEMBER)) {
			month = 10;
		} else if (accessMonth.equals(DECEMBER)) {
			month = 11;
		}

		return month;
	}

	public boolean isCheckCalendarFilter(boolean isCheckDate, Date logDate) {
		if (!isCheckDate) {
			return true;
		}
		boolean isHit = false;

		Date startDate = LogDataFilterInfo.getInstance().getStartDate();
		Date endDate = LogDataFilterInfo.getInstance().getEndDate();
		if (startDate == null || endDate == null) {
			return true;
		}

		if (startDate.getTime() <= logDate.getTime()
				&& endDate.getTime() >= logDate.getTime()) {

			return true;
		}
		return isHit;
	}

	public boolean isCheckCalendarFilter2(Date fileNameDate) {
		boolean isHit = false;

		Date startDate = LogDataFilterInfo.getInstance().getFileNameStartDate();

		Date endDate = LogDataFilterInfo.getInstance().getFileNameEndDate();
		if (startDate == null || endDate == null) {
			return true;
		}

		if (startDate.getTime() <= fileNameDate.getTime()
				&& endDate.getTime() >= fileNameDate.getTime()) {

			return true;
		}
		return isHit;
	}

	public Date setStringToDate(String dateString) {

		Pattern pattern;
		pattern = Pattern.compile("[ \t]");

		String[] dateWorkArray;
		dateWorkArray = pattern.split(dateString, 2);

		String[] dateItemArray;
		pattern = Pattern.compile("[:]");
		dateItemArray = pattern.split(dateWorkArray[0], 2);

		String[] dateItemArray2;
		pattern = Pattern.compile("[/]");
		dateItemArray2 = pattern.split(dateItemArray[0], 3);
		String accessDay;
		String accessMonth;
		String accessYear;
		accessDay = dateItemArray2[0];
		accessMonth = dateItemArray2[1];
		accessYear = dateItemArray2[2];

		String[] dateItemArray3;
		pattern = Pattern.compile("[:]");
		dateItemArray3 = pattern.split(dateItemArray[1], 3);
		String accessHour;
		String accessMinuts;
		String accessSecond;
		accessHour = dateItemArray3[0];
		accessMinuts = dateItemArray3[1];
		accessSecond = dateItemArray3[2];

		Calendar cal = Calendar.getInstance();
		cal.set(Integer.parseInt(accessYear), CalendarControl.getInstance()
				.getMonthData(accessMonth), Integer.parseInt(accessDay),
				Integer.parseInt(accessHour), Integer.parseInt(accessMinuts),
				Integer.parseInt(accessSecond));
		Date logDate = cal.getTime();

		// System.out.println("logDate " + logDate.toString());

		return logDate;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static CalendarControl getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final CalendarControl RESOURCE = new CalendarControl();
	}

}
