/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.model;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class ClientDomain {

	public String getDomain(String ipAddress) {

		String domainName = "";

		try {
			InetAddress host = InetAddress.getByName(ipAddress);
			domainName = host.getHostName();
		} catch (UnknownHostException e2) {
			domainName = "UnknownHost";
		}

		return domainName;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static ClientDomain getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final ClientDomain RESOURCE = new ClientDomain();
	}
}
