/* xfce4-newsreader-plugin - A lightweight RSS/Atom news feed reader on xfce4-panel
 * 
 * Copyright 2005 mueki <mueki@users.sourceforge.jp>
 * Written for rssreader.
 *
 * httpfetch.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h> /* getenv */
#include <string.h> /* memcpy */
#include <ne_socket.h>
#include <ne_session.h>
#include <ne_uri.h>
#include <ne_basic.h>
#include <ne_utils.h>
#include <ne_request.h>
#include <ne_dates.h>
#include <glib.h>

#include "httpfetch.h"

#ifdef DEBUG
#define DEBUG_PRINT(...) g_message("httpfetch** " __VA_ARGS__);
#else
#define DEBUG_PRINT(...)
#endif

static void init_proxy(ne_session* ne_sess)
{
	char *pchProxy; 
	ne_uri uri = {0};

 	if((pchProxy = getenv("http_proxy")) != NULL){

		DEBUG_PRINT("use proxy: %s", pchProxy);

		if(ne_uri_parse(pchProxy, &uri) 
		   || uri.host == NULL){
			DEBUG_PRINT("Coud not parse proxy URI");
			return;
		}
		if (uri.scheme == NULL){
			DEBUG_PRINT("not found uri scheme");
			uri.scheme = "http";
		}
		if(uri.port == 0){
			DEBUG_PRINT("use default port");
			uri.port = ne_uri_defaultport(uri.scheme);
		}

		ne_session_proxy(ne_sess, uri.host, uri.port);
	}

	return;
}

static void
buffer_append(void* userdata, const char* buff, size_t len)
{
	ne_buffer* ne_buf = (ne_buffer*)userdata;

	if(len == 0)
		return;

	if((ne_buf->length - ne_buf->used) < len){
		ne_buffer_grow(ne_buf, ne_buf->used + len);
	}

	memcpy(&ne_buf->data[ne_buf->used], buff, len);
	ne_buf->used += len;

	return;
}

/*
static void
buffer_append(void* userdata, const char* buff, size_t len)
{
	GString* strBuff = (GString*)userdata;
	
	if(len == 0)
		return;

	g_string_append_len(strBuff, buff, len);

	return;
	
}
*/

/*int
httpfetch(const char* strURI, char* const buff, int bufflen, 
time_t tmModified, time_t* ptmRetModified)*/

int
httpfetch(const char* strURI, char** ppBuff, 
		  time_t tmModified, time_t* ptmRetModified)
{
	ne_session *ne_sess = NULL;
	ne_request *ne_req = NULL;
	ne_buffer* ne_buf;
	ne_buffer* ne_header_buf;
	ne_uri uri = {0};
	int retlen = 0;

	*ppBuff = NULL;

	if(!strURI || !ppBuff){
		g_error("invalid arg");
		return HF_ERROR;
	}
	
	ne_buf = ne_buffer_create();
	ne_header_buf = ne_buffer_create();
	
	ne_buf->used = 0;
	ne_header_buf->used = 0;

    /* Initialize socket libraries */
    if (ne_sock_init()) {
        DEBUG_PRINT("Failed to initialize socket libraries.");
		retlen = HF_ERROR;
		goto ret;
    }

	if(ne_uri_parse(strURI, &uri) 
	   || uri.host == NULL || uri.path == NULL){
		DEBUG_PRINT("Coud not parse URI");
		retlen = HF_ERROR;
		goto ret;
	}
	   
	/* Set defaults. */
    if (uri.scheme == NULL)
        uri.scheme = "http";
    if (uri.port == 0)
        uri.port = ne_uri_defaultport(uri.scheme);

	/* Create session. */
    ne_sess = ne_session_create(uri.scheme, uri.host, uri.port);

	/* proxy setting */
	init_proxy(ne_sess);

	ne_set_read_timeout(ne_sess, 10);

	/* Create request. */
	ne_req = ne_request_create(ne_sess, "GET", uri.path);
	ne_add_response_body_reader(ne_req, ne_accept_always, (ne_block_reader)buffer_append, ne_buf);

	ne_add_response_header_handler(ne_req, "Last-Modified", ne_duplicate_header,ne_header_buf);
	
	if(tmModified > -1){
		char* chDate = (char*)ne_rfc1123_date(tmModified);
		DEBUG_PRINT("modified str: %s\n", chDate);
		ne_add_request_header(ne_req, "If-Modified-Since", chDate);
		free(chDate);
	}

	if(NE_OK != ne_request_dispatch(ne_req)){
		DEBUG_PRINT("dispatch error");
		retlen = HF_ERROR;
		goto ret;
	}

	if(304 == ne_get_status(ne_req)->code){
		DEBUG_PRINT("return code 304");
		retlen = HF_NOT_MODIFIED;
		goto ret;
	}


	if(ptmRetModified){
		*ptmRetModified = ne_rfc1123_parse(ne_header_buf->data);
		DEBUG_PRINT("modified %d\n", (int)*ptmRetModified);
	}

	if(ne_buf->used > 0){
		retlen = ne_buf->used + 1;
		*ppBuff = malloc(retlen);
		memcpy(*ppBuff, ne_buf->data, retlen - 1);
		(*ppBuff)[retlen - 1] = '\0';
	}
	
 ret:
	ne_buffer_destroy(ne_buf);
	ne_buffer_destroy(ne_header_buf);
	if(ne_req)ne_request_destroy(ne_req);
	if(ne_sess)ne_session_destroy(ne_sess);
	ne_sock_exit();
	DEBUG_PRINT("return: %d", retlen);
	return retlen;
}
