
// NHKKifuDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NHKKifu.h"
#include "NHKKifuDlg.h"

#include <fstream>
#include <string>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

namespace {

	/**
	 * 񃊃Xg̃J.
	 */
	enum {
		/// 
		Column_OnAir,
		/// Xe[W
		Column_Stage,
		/// 
		Column_Player1,
		/// 
		Column_Player2,
	};

	/// 擾|[O^C}[ ID
	static const UINT TIMER_POLLING_ID     = 1;
	/// 擾|[O^C}[Ԋu (ms)
	static const UINT TIMER_POLLING_ELAPSE = 500;

	/**
	 * /t Player 擾.
	 */
	CString GetPlayer(LPCTSTR player, bool win)
	{
		CString str;
		str.Format(_T("%s %s"), win ? _T("") : _T("~"), player);
		return str;
	}

}	// anonymous namespace



// CNHKKifuDlg dialog

CNHKKifuDlg::CNHKKifuDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNHKKifuDlg::IDD, pParent)
	, m_strFileFormat(_T(""))
	, m_strServer(_T(""))
	, m_strKif(_T(""))
	, m_year(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNHKKifuDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_SERVER, m_strServer);
	DDX_Text(pDX, IDC_EDIT_FILEFORMAT, m_strFileFormat);
	DDX_Text(pDX, IDC_EDIT_KIF, m_strKif);
	DDX_Text(pDX, IDC_EDIT_YEAR, m_year);
	DDV_MinMaxUInt(pDX, m_year, 2009, 2100);
	DDX_Control(pDX, IDC_LIST_KIFDATA, m_listKifData);
}

BEGIN_MESSAGE_MAP(CNHKKifuDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON_GET, &CNHKKifuDlg::OnBnClickedButtonGet)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_KIFDATA, &CNHKKifuDlg::OnLvnItemchangedListKifdata)
	ON_BN_CLICKED(IDC_BUTTON_SAVEALL, &CNHKKifuDlg::OnBnClickedButtonSaveall)
	ON_BN_CLICKED(IDC_BUTTON_SAVE, &CNHKKifuDlg::OnBnClickedButtonSave)
	ON_BN_CLICKED(IDC_BUTTON_COPY, &CNHKKifuDlg::OnBnClickedButtonCopy)
	ON_WM_TIMER()
	ON_WM_SETCURSOR()
END_MESSAGE_MAP()

// CNHKKifuDlg message handlers

BOOL CNHKKifuDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// T[o[
	m_strServer = _T("cgi2.nhk.or.jp");
	// t@CtH[}bg
	m_strFileFormat = _T("goshogi/kifu/score.cgi?d=%y%m%d&t=s");

	// ݂̔Nx擾
	COleDateTime now = COleDateTime::GetCurrentTime();
	if (now.GetMonth() >= 4) {
		m_year = now.GetYear();
	}
	else {
		m_year = now.GetYear() - 1;
	}

	// 񃊃Xg
	m_listKifData.SetExtendedStyle(LVS_EX_FULLROWSELECT);
	m_listKifData.InsertColumn(Column_OnAir, _T(""), 0, 80);
	m_listKifData.InsertColumn(Column_Stage, _T("Xe[W"), 0, 110);
	m_listKifData.InsertColumn(Column_Player1, _T(""), 0, 130);
	m_listKifData.InsertColumn(Column_Player2, _T(""), 0, 130);

	UpdateData(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNHKKifuDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNHKKifuDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CNHKKifuDlg::OnBnClickedButtonGet()
{
	// TODO: Add your control notification handler code here

	if (!UpdateData()) {
		return;
	}

	// f[^擾 (񓯊)
	if (!m_kifData.GetKif(m_strServer, m_strFileFormat, m_year)) {
		return;
	}

	m_listKifData.DeleteAllItems();
	m_strKif.Empty();

	UpdateData(FALSE);

	// HACK: f[^̎擾|[O
	VERIFY(SetTimer(TIMER_POLLING_ID, TIMER_POLLING_ELAPSE, NULL) == TIMER_POLLING_ID);
}

void CNHKKifuDlg::OnLvnItemchangedListKifdata(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here
	*pResult = 0;

	// ڂIꂽ
	if (pNMLV->uNewState & LVIS_SELECTED) {
		if (UpdateData()) {
			m_strKif.Empty();
			if (m_kifData.GetKifDataSize() > (size_t)pNMLV->iItem) {
				// kif f[^擾
				m_strKif = m_kifData.GetKifData(pNMLV->iItem).kif.c_str();
				// HACK: \邽߂ \n  \r\n ɕϊ
				m_strKif.Replace(_T("\n"), _T("\r\n"));
			}

			UpdateData(FALSE);
		}
	}
}

void CNHKKifuDlg::OnBnClickedButtonSaveall()
{
	// TODO: Add your control notification handler code here

	// ۑtH_擾
	CFileDialog fd(FALSE, NULL, _T("(tH_IĂ)"), OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY, _T("Kif Files (*.kif)|*.kif|All Files|*.*||"), this);
	if (fd.DoModal() == IDOK) {
		// HACK: PathName tH_擾 (GetFolderPath()  XP Ŏs)
		CString folder = fd.GetPathName();
		VERIFY(::PathRemoveFileSpec(folder.GetBuffer(MAX_PATH)));
		folder.ReleaseBuffer();

		// ׂẴf[^t@Cɕۑ
		if (!m_kifData.SaveAll(folder)) {
			AfxMessageBox(_T("t@C̕ۑɎs܂"));
		}
	}
}

void CNHKKifuDlg::OnBnClickedButtonSave()
{
	// TODO: Add your control notification handler code here

	POSITION pos = m_listKifData.GetFirstSelectedItemPosition();
	if (!pos) {
		return;
	}
	// IĂ鍀
	size_t index = m_listKifData.GetNextSelectedItem(pos);
	if (index >= m_kifData.GetKifDataSize()) {
		return;
	}

	// ۑt@C擾
	CFileDialog fd(FALSE, _T(".kif"), m_kifData.GetDefaultFileName(index), OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY, _T("Kif Files (*.kif)|*.kif|All Files|*.*||"), this);
	if (fd.DoModal() == IDOK) {
		// t@Cɕۑ
		if (!m_kifData.Save(index, fd.GetPathName())) {
			AfxMessageBox(_T("t@C̕ۑɎs܂"));
		}
	}
}

void CNHKKifuDlg::OnBnClickedButtonCopy()
{
	// TODO: Add your control notification handler code here

	POSITION pos = m_listKifData.GetFirstSelectedItemPosition();
	if (!pos) {
		return;
	}
	// IĂ鍀
	size_t index = m_listKifData.GetNextSelectedItem(pos);
	if (index >= m_kifData.GetKifDataSize()) {
		return;
	}

	// Nbv{[hɃRs[
	if (!m_kifData.Copy(index)) {
		AfxMessageBox(_T("Rs[Ɏs܂"));
	}
}

void CNHKKifuDlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: Add your message handler code here and/or call default

	// 擾|[O^C}[
	if (nIDEvent == TIMER_POLLING_ID) {
		VERIFY(KillTimer(TIMER_POLLING_ID));

		// 擾^XN̏
		// HACK: ɂׂẴf[^mɎ擾邽߂ɁAGetKifDataSize() OɎ擾Ȃ΂ȂȂ
		CString errmsg;
		CKifData::Status status = m_kifData.GetStatus(errmsg);
		if (status == CKifData::S_FAILED) {
			AfxMessageBox(errmsg);
			return;
		}

		// ݂̃ACe
		size_t count = m_listKifData.GetItemCount();
		// ܂łɎ擾łf[^
		size_t size = m_kifData.GetKifDataSize();
		ASSERT(count <= size);

		// O񂩂ςĂȂ
		if (count >= size) {
			if (status == CKifData::S_BUSY) {
				VERIFY(SetTimer(TIMER_POLLING_ID, TIMER_POLLING_ELAPSE, NULL) == TIMER_POLLING_ID);
			}
			else if (size == 0) {
				AfxMessageBox(_T("Yf[^݂܂"));
			}
			return;
		}

		// 擾f[^Xgɒǉ
		for (size_t i = count; i < size; ++i) {
			KifData kifData = m_kifData.GetKifData(i);
			m_listKifData.InsertItem(i, kifData.onAir.c_str());
			m_listKifData.SetItemText(i, Column_Stage, kifData.stage.c_str());
			m_listKifData.SetItemText(i, Column_Player1, GetPlayer(kifData.player1.c_str(), kifData.moves % 2 == 1));
			m_listKifData.SetItemText(i, Column_Player2, GetPlayer(kifData.player2.c_str(), kifData.moves % 2 == 0));
		}

		// ߂ăf[^ǉꂽ
		if (count == 0 && size > 0) {
			// ŏ̃f[^I
			m_listKifData.SetItemState(0, LVIS_SELECTED, LVIS_SELECTED);
		}

		if (status == CKifData::S_BUSY) {
			VERIFY(SetTimer(TIMER_POLLING_ID, TIMER_POLLING_ELAPSE, NULL) == TIMER_POLLING_ID);
		}
	}

	CDialog::OnTimer(nIDEvent);
}

BOOL CNHKKifuDlg::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
	// TODO: Add your message handler code here and/or call default

	// HACK: Busy ̓J[\ύX
	CString errmsg;
	if (m_kifData.GetStatus(errmsg) == CKifData::S_BUSY) {
		::SetCursor(::LoadCursor(NULL, IDC_APPSTARTING));
		return TRUE;
	}
	else {
		return CDialog::OnSetCursor(pWnd, nHitTest, message);
	}
}
