package jp.sf.nikonikofw.persistence;

import java.util.Properties;

import jp.sf.nikonikofw.exception.InitializeException;

public interface IPersistenceManager {
	
	public void init(Properties props) throws InitializeException;
	
	/**
	 * トランザクションを開始します。
	 */
	public void begin();
	
	/**
	 * トランザクションをコミットします。
	 */
	public void commit();
	
	/**
	 * トランザクションをロールバックします。
	 */
	public void rollback();
	
	/**
	 * コネクションを切断します。
	 */
	public void close();
}
