package jp.sf.nikonikofw.persistence.jdbc;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import jp.sf.nikonikofw.Config;
import jp.sf.nikonikofw.persistence.jdbc.annotation.Column;
import jp.sf.nikonikofw.persistence.jdbc.annotation.PrimaryKey;
import jp.sf.nikonikofw.persistence.jdbc.annotation.Table;
import jp.sf.nikonikofw.util.StringUtils;

/**
 * エンティティのメタ情報を表すクラスです。
 * 
 * @author Naoki Takezoe
 */
public class TableMeta {
	
	private String tableName;
	
	private List<ColumnMeta> columns = new ArrayList<ColumnMeta>();
	
	
	public String getTableName() {
		return tableName;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public List<ColumnMeta> getColumns() {
		return columns;
	}

	public void setColumns(List<ColumnMeta> columns) {
		this.columns = columns;
	}

	/**
	 * エンティティのクラスオブジェクトからメタ情報を取得します。
	 * <p>
	 * TODO TableMetaはキャッシュするようにしたい
	 * 
	 * @param entityClass エンティティのクラスオブジェクト
	 * @return エンティティのメタ情報
	 */
	public static TableMeta getTableMeta(Class<?> entityClass){
		INaming naming = ((JdbcPersistenceManager) Config.getPersistenceManager()).getNaming();
		
		TableMeta tableMeta = new TableMeta();
		
		Table tableAnn = entityClass.getAnnotation(Table.class);
		if(tableAnn != null && StringUtils.isNotEmpty(tableAnn.name())){
			tableMeta.setTableName(tableAnn.name());
		} else {
			tableMeta.setTableName(naming.toDatabaseName(entityClass.getSimpleName()));
		}
		
		for(Field field: entityClass.getDeclaredFields()){
			field.setAccessible(true);
			
			Column columnAnn = field.getAnnotation(Column.class);
			if(columnAnn != null){
				ColumnMeta column = new ColumnMeta();
				column.setField(field);
				column.setPk(field.getAnnotation(PrimaryKey.class) != null);
				
				column.setColumnName(naming.toDatabaseName(field.getName()));
				if(StringUtils.isNotEmpty(columnAnn.name())){
					column.setColumnName(columnAnn.name());
				}
				
				tableMeta.getColumns().add(column);
			}
			
		}
		
		return tableMeta;
	}
	
}
