package jp.sf.nikonikofw.persistence.jdbc.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * エンティティにマッピングするテーブル名を明示的に指定したい場合に付与します。
 * 
 * @author Naoki Takezoe
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Table {
	
	/**
	 * マッピングするテーブル名。
	 */
	String name() default "";
	
}
