package jp.sf.nikonikofw.persistence.jdo;

import java.util.Properties;
import java.util.logging.Logger;

import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;

import jp.sf.nikonikofw.exception.InitializeException;
import jp.sf.nikonikofw.persistence.IPersistenceManager;

/**
 * Google App EngineのJDO利用時に使用するための<code>IPersistenceManager</code>実装です。
 * 
 * @author Naoki Takezoe
 */
public class JdoPersistenceManager implements IPersistenceManager {

	private Logger logger = Logger.getLogger(JdoPersistenceManager.class.getName());
	
	private static PersistenceManagerFactory pmf 
		= JDOHelper.getPersistenceManagerFactory("transactions-optional");
	
	private static ThreadLocal<PersistenceManager> threadLocal = new ThreadLocal<PersistenceManager>();
	
	@Override
	public void begin() {
		PersistenceManager pm = pmf.getPersistenceManager();
		pm.currentTransaction().begin();
		threadLocal.set(pm);
		
		logger.info("トランザクションを開始しました。");
	}

	@Override
	public void close() {
		try {
			PersistenceManager pm = getPersistenceManager();
			pm.currentTransaction().commit();
			pm.close();
			
			logger.info("コネクションをクローズしました。");
		} finally {
			threadLocal.remove();
		}
	}
	
	public PersistenceManager getPersistenceManager(){
		return threadLocal.get();
	}

	@Override
	public void commit() {
		getPersistenceManager().currentTransaction().commit();
		logger.info("トランザクションをコミットしました。");
	}

	@Override
	public void init(Properties props) throws InitializeException {
	}

	@Override
	public void rollback() {
		getPersistenceManager().currentTransaction().rollback();
		logger.info("トランザクションをロールバックしました。");
	}

}
