package jp.sf.nikonikofw.persistence.jdo;

import jp.sf.nikonikofw.Config;

/**
 * JDOの操作を簡単に行うためのユーティリティクラスです。
 * 
 * @author Naoki Takezoe
 */
public class JdoUtil {
	
	public static <T> JdoQuery<T> from(Class<T> entityClass){
		return new JdoQuery<T>(entityClass);
	}
	
	public static void makePersistence(Object entity){
		JdoPersistenceManager manager = (JdoPersistenceManager) Config.getPersistenceManager();
		manager.getPersistenceManager().makePersistent(entity);
	}
	
	public static void deletePersistent(Object entity){
		JdoPersistenceManager manager = (JdoPersistenceManager) Config.getPersistenceManager();
		manager.getPersistenceManager().deletePersistent(entity);
	}
	

}
