package jp.sf.nikonikofw.persistence.jdo;

import java.util.Collection;

import jp.sf.nikonikofw.Config;

/**
 * JDOの操作を簡単に行うためのユーティリティクラスです。
 * 
 * @author Naoki Takezoe
 */
public class JdoUtil {
	
	public static <T> JdoQuery<T> from(Class<T> entityClass){
		return new JdoQuery<T>(entityClass);
	}
	
	public static void insert(Object entity){
		JdoPersistenceManager manager = (JdoPersistenceManager) Config.getPersistenceManager();
		manager.getPersistenceManager().makePersistent(entity);
	}
	
	public static void delete(Object entity){
		JdoPersistenceManager manager = (JdoPersistenceManager) Config.getPersistenceManager();
		manager.getPersistenceManager().deletePersistent(entity);
	}
	
	public static void deleteAll(Collection<?> entities){
		JdoPersistenceManager manager = (JdoPersistenceManager) Config.getPersistenceManager();
		manager.getPersistenceManager().deletePersistentAll(entities);
	}
	
	public static <T> T getObjectById(Class<T> entityClass,Object id){
		JdoPersistenceManager manager = (JdoPersistenceManager) Config.getPersistenceManager();
		return manager.getPersistenceManager().getObjectById(entityClass, id);
	}
	

}
