package jp.sf.nikonikofw.util;

import jp.sf.nikonikofw.Config;

/**
 * JSPのELで利用可能な関数を提供します。
 * 
 * @author Naoki Takezoe
 */
public class Functions {
	
	public static String h(String value){
		return StringUtils.escapeHtml(value);
	}
	
	public static String br(String value){
		return StringUtils.convertBr(value);
	}
	
	public static String js(String value){
		return StringUtils.escapeJavaScript(value);
	}
	
	public static String link(String value){
		return StringUtils.convertLink(value);
	}
	
	public static boolean isLogin(){
		return Config.getAuthenticationMananger().isLogin();
	}
	
	public static boolean isAdmin(){
		return Config.getAuthenticationMananger().isAdmin();
	}
}
