/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.core;

import java.io.Serializable;
import jp.ossc.nimbus.core.DeploymentException;
import jp.ossc.nimbus.core.MetaData;
import jp.ossc.nimbus.core.ObjectMetaData;
import jp.ossc.nimbus.core.ServiceRefMetaData;
import org.w3c.dom.Element;

public class ArgumentMetaData
extends MetaData
implements Serializable {
    public static final String ARGUMENT_TAG_NAME = "argument";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String VALUE_TYPE_ATTRIBUTE_NAME = "valueType";
    private static final String TYPE_ATTRIBUTE_NULL_VALUE = "nullValue";
    private ObjectMetaData parentObjData;
    private String type;
    private String valueType;
    private Object value;
    private boolean isNullValue;

    public ArgumentMetaData(MetaData parent, ObjectMetaData objData) {
        super(parent);
        this.parentObjData = objData;
    }

    public ObjectMetaData getParentObjectMetaData() {
        return this.parentObjData;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String type) {
        this.valueType = type;
    }

    public boolean isNullValue() {
        return this.isNullValue;
    }

    public void setNullValue(boolean flg) {
        this.isNullValue = flg;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void importXML(Element element) throws DeploymentException {
        Element serviceRefElement;
        super.importXML(element);
        if (!element.getTagName().equals(ARGUMENT_TAG_NAME)) {
            throw new DeploymentException("Tag must be argument : " + element.getTagName());
        }
        this.type = ArgumentMetaData.getOptionalAttribute(element, TYPE_ATTRIBUTE_NAME);
        this.valueType = ArgumentMetaData.getOptionalAttribute(element, VALUE_TYPE_ATTRIBUTE_NAME);
        String isNullValueStr = ArgumentMetaData.getOptionalAttribute(element, TYPE_ATTRIBUTE_NULL_VALUE);
        if (isNullValueStr != null) {
            this.isNullValue = Boolean.valueOf(isNullValueStr);
        }
        if ((serviceRefElement = ArgumentMetaData.getOptionalChild(element, "service-ref")) != null) {
            ServiceRefMetaData serviceRefData = new ServiceRefMetaData(this, this.parentObjData.getManagerName());
            serviceRefData.importXML(serviceRefElement);
            this.value = serviceRefData;
            return;
        }
        Element objectElement = ArgumentMetaData.getOptionalChild(element, "object");
        if (objectElement != null) {
            ObjectMetaData objectData = new ObjectMetaData(this.parentObjData.getServiceLoader(), this, this.parentObjData.getManagerName());
            objectData.importXML(objectElement);
            this.value = objectData;
            return;
        }
        this.value = ArgumentMetaData.getElementContent(element);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('{');
        if (this.getType() != null) {
            buf.append(TYPE_ATTRIBUTE_NAME);
            buf.append('=');
            buf.append(this.getType());
            buf.append(',');
        }
        buf.append(this.value);
        buf.append('}');
        return buf.toString();
    }
}

