/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.service.proxy;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import jp.ossc.nimbus.core.ServiceBase;
import jp.ossc.nimbus.core.ServiceManagerFactory;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceNotFoundException;
import jp.ossc.nimbus.service.aop.DefaultInterceptorChain;
import jp.ossc.nimbus.service.aop.InvocationContext;
import jp.ossc.nimbus.service.aop.Invoker;
import jp.ossc.nimbus.service.aop.invoker.MethodReflectionCallInvokerService;
import jp.ossc.nimbus.service.proxy.RemoteServerInvoker;
import jp.ossc.nimbus.service.proxy.RemoteServiceServerServiceMBean;
import jp.ossc.nimbus.service.repository.Repository;

public class RemoteServiceServerService
extends ServiceBase
implements RemoteServiceServerServiceMBean {
    private ServiceName remoteServiceName;
    private ServiceName interceptorChainListServiceName;
    private ServiceName invokerServiceName;
    private MethodReflectionCallInvokerService defaultInvoker;
    private ServiceName jndiRepositoryServiceName;
    private Repository jndiRepository;
    private String jndiName;
    private int rmiPort;

    public void setRemoteServiceName(ServiceName name) {
        this.remoteServiceName = name;
    }

    public ServiceName getRemoteServiceName() {
        return this.remoteServiceName;
    }

    public void setInterceptorChainListServiceName(ServiceName name) {
        this.interceptorChainListServiceName = name;
    }

    public ServiceName getInterceptorChainListServiceName() {
        return this.interceptorChainListServiceName;
    }

    public void setInvokerServiceName(ServiceName name) {
        this.invokerServiceName = name;
    }

    public ServiceName getInvokerServiceName() {
        return this.invokerServiceName;
    }

    public void setJndiName(String name) {
        this.jndiName = name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiRepositoryServiceName(ServiceName name) {
        this.jndiRepositoryServiceName = name;
    }

    public ServiceName getJndiRepositoryServiceName() {
        return this.jndiRepositoryServiceName;
    }

    public void setRMIPort(int port) {
        this.rmiPort = port;
    }

    public int getRMIPort() {
        return this.rmiPort;
    }

    public void createService() throws Exception {
    }

    public void startService() throws Exception {
        if (this.getInvokerServiceName() == null) {
            if (this.defaultInvoker == null) {
                this.defaultInvoker = new MethodReflectionCallInvokerService();
                this.defaultInvoker.create();
                this.defaultInvoker.start();
            } else {
                this.defaultInvoker.start();
            }
        } else {
            Invoker invoker = (Invoker)ServiceManagerFactory.getServiceObject(this.getInvokerServiceName());
            this.defaultInvoker = null;
        }
        if (this.jndiRepositoryServiceName == null) {
            throw new IllegalArgumentException("jndiRepositoryServiceName must be specified.");
        }
        if (this.jndiName == null) {
            this.jndiName = this.remoteServiceName.getServiceManagerName() + '/' + this.remoteServiceName.getServiceName();
        }
        this.jndiRepository = (Repository)ServiceManagerFactory.getServiceObject(this.jndiRepositoryServiceName);
        if (!this.jndiRepository.register(this.jndiName, new RemoteServerInvokerImpl(this.interceptorChainListServiceName, this.invokerServiceName, this.defaultInvoker, this.remoteServiceName, this.rmiPort))) {
            throw new Exception("Could not register in jndiRepository.");
        }
    }

    public void stopService() throws Exception {
        if (this.defaultInvoker != null) {
            this.defaultInvoker.stop();
        }
        this.jndiRepository.unregister(this.jndiName);
    }

    public void destroyService() throws Exception {
        if (this.defaultInvoker != null) {
            this.defaultInvoker.destroy();
            this.defaultInvoker = null;
        }
    }

    public static class RemoteServerInvokerImpl
    extends UnicastRemoteObject
    implements RemoteServerInvoker {
        private final ServiceName interceptorChainListServiceName;
        private final ServiceName invokerServiceName;
        private final Invoker defaultInvoker;
        private final ServiceName remoteServiceName;

        public RemoteServerInvokerImpl(ServiceName interceptorChainListServiceName, ServiceName invokerServiceName, Invoker defaultInvoker, ServiceName remoteServiceName, int port) throws RemoteException {
            super(port);
            this.interceptorChainListServiceName = interceptorChainListServiceName;
            this.invokerServiceName = invokerServiceName;
            this.defaultInvoker = defaultInvoker;
            this.remoteServiceName = remoteServiceName;
        }

        public Object invoke(InvocationContext context) throws Exception {
            DefaultInterceptorChain chain = new DefaultInterceptorChain(this.interceptorChainListServiceName, this.invokerServiceName);
            if (this.invokerServiceName == null && this.defaultInvoker != null) {
                chain.setInvoker(this.defaultInvoker);
            }
            ServiceName serviceName = null;
            if (context.getTargetObject() != null && context.getTargetObject() instanceof ServiceName) {
                serviceName = (ServiceName)context.getTargetObject();
                if (this.remoteServiceName != null && !this.remoteServiceName.equals(serviceName)) {
                    throw new IllegalAccessException(serviceName + " don't be allowed access.");
                }
            } else {
                serviceName = this.remoteServiceName;
            }
            if (serviceName != null) {
                context.setTargetObject(ServiceManagerFactory.getServiceObject(serviceName));
                try {
                    return chain.invokeNext(context);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return null;
                }
            }
            throw new ServiceNotFoundException(null);
        }
    }
}

