/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.DataSetException;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.beans.dataset.Record;
import jp.ossc.nimbus.beans.dataset.RecordSchema;
import org.apache.commons.jexl.Expression;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;

public class RecordList
implements Serializable,
List,
Cloneable {
    private static final long serialVersionUID = 6399184480196775369L;
    protected String name;
    protected String schema;
    protected transient RecordSchema recordSchema;
    protected List records = Collections.synchronizedList(new ArrayList());
    protected Map stockSearchConditionMap;
    protected Map stockSearchResultMap;

    public RecordList(String name, String schema) throws PropertySchemaDefineException {
        this.name = name;
        this.schema = schema;
        this.recordSchema = RecordSchema.getInstance(schema);
    }

    public RecordList(String name, RecordSchema schema) throws PropertySchemaDefineException {
        this.name = name;
        this.schema = schema.getSchema();
        this.recordSchema = schema;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public RecordSchema getRecordSchema() {
        return this.recordSchema;
    }

    public Record createRecord() {
        return new Record(this.schema, this.recordSchema);
    }

    public Record getRecord(int index) {
        return (Record)this.get(index);
    }

    public void addRecord(Record r) {
        this.add(r);
    }

    public void addRecord(int index, Record r) {
        this.add(index, r);
    }

    public Record setRecord(int index, Record r) {
        return (Record)this.set(index, r);
    }

    public void removeRecord(Record r) {
        this.remove(r);
    }

    public Record removeRecord(int index) {
        return (Record)this.remove(index);
    }

    public void setStockSearchCondition(String name, String condition) throws DataSetException {
        if (this.stockSearchConditionMap == null) {
            this.stockSearchConditionMap = new HashMap();
        }
        if (this.recordSchema == null) {
            throw new DataSetException("Schema not initalize.");
        }
        try {
            Expression exp = ExpressionFactory.createExpression((String)condition);
            this.stockSearchConditionMap.put(name, exp);
        }
        catch (Exception e) {
            throw new DataSetException(e);
        }
        if (this.stockSearchResultMap == null) {
            this.stockSearchResultMap = new HashMap();
        }
    }

    public RecordList stockSearch(String name) {
        RecordList clone = this.cloneSchema();
        if (this.stockSearchResultMap == null || this.stockSearchResultMap.size() == 0) {
            return clone;
        }
        List values = (List)this.stockSearchResultMap.get(name);
        if (values == null) {
            return clone;
        }
        clone.addAll((Collection)values);
        return clone;
    }

    protected void stockSearchResult(Record record) throws DataSetException {
        if (this.stockSearchConditionMap == null || this.stockSearchConditionMap.size() == 0) {
            return;
        }
        try {
            Iterator entries = this.stockSearchConditionMap.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                String name = (String)entry.getKey();
                Expression exp = (Expression)entry.getValue();
                JexlContext context = JexlHelper.createContext();
                int imax = this.recordSchema.getPropertySize();
                for (int i = 0; i < imax; ++i) {
                    PropertySchema prop = this.recordSchema.getPropertySchema(i);
                    String propName = prop.getName();
                    context.getVars().put(propName, record.getProperty(propName));
                }
                Object ret = exp.evaluate(context);
                if (!(ret instanceof Boolean)) {
                    throw new DataSetException("Illegal condition : " + exp.getExpression());
                }
                boolean isMatch = (Boolean)ret;
                if (!isMatch) continue;
                List values = (List)this.stockSearchResultMap.get(name);
                values.add(record);
            }
        }
        catch (DataSetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataSetException(e);
        }
    }

    public RecordList realSearch(String condition, Map valueMap) throws DataSetException {
        RecordList result = this.cloneSchema();
        if (this.size() == 0) {
            return result;
        }
        try {
            Expression exp = ExpressionFactory.createExpression((String)condition);
            JexlContext context = JexlHelper.createContext();
            int imax = this.size();
            for (int i = 0; i < imax; ++i) {
                Boolean ret;
                Record rd = this.getRecord(i);
                int jmax = this.recordSchema.getPropertySize();
                for (int j = 0; j < jmax; ++j) {
                    PropertySchema prop = this.recordSchema.getPropertySchema(j);
                    String propName = prop.getName();
                    context.getVars().put(propName, rd.getProperty(propName));
                }
                if (valueMap != null) {
                    context.getVars().putAll(valueMap);
                }
                if ((ret = (Boolean)exp.evaluate(context)) == null || !ret.booleanValue()) continue;
                result.add(rd);
            }
        }
        catch (Exception e) {
            throw new DataSetException(e);
        }
        return result;
    }

    public void sort(String[] orderBy) {
        this.sort(orderBy, null);
    }

    public void sort(int[] orderBy) {
        this.sort(orderBy, null);
    }

    public void sort(int[] orderBy, boolean[] isAsc) {
        if (this.records.size() < 2) {
            return;
        }
        Collections.sort(this.records, new RecordComparator(orderBy, isAsc));
    }

    public void sort(String[] orderBy, boolean[] isAsc) {
        if (this.records.size() < 2) {
            return;
        }
        Collections.sort(this.records, new RecordComparator(orderBy, isAsc));
    }

    public int size() {
        return this.records.size();
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public boolean contains(Object o) {
        return this.records.contains(o);
    }

    public Iterator iterator() {
        return this.records.iterator();
    }

    public ListIterator listIterator() {
        return this.records.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.records.listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.records.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.records.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.records.toArray(a);
    }

    public boolean add(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Record)) {
            throw new DataSetException("Not record : " + o);
        }
        this.stockSearchResult((Record)o);
        return this.records.add(o);
    }

    public void add(int index, Object element) {
        if (element == null) {
            return;
        }
        if (!(element instanceof Record)) {
            throw new DataSetException("Not record : " + element);
        }
        this.stockSearchResult((Record)element);
        this.records.add(index, element);
    }

    public Object set(int index, Object element) {
        return this.records.set(index, element);
    }

    public Object get(int index) {
        return this.records.get(index);
    }

    public int indexOf(Object o) {
        return this.records.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.records.lastIndexOf(o);
    }

    public boolean remove(Object o) {
        return this.records.remove(o);
    }

    public Object remove(int index) {
        return this.records.remove(index);
    }

    public boolean containsAll(Collection c) {
        return this.records.containsAll(c);
    }

    public boolean addAll(Collection c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        Object[] vals = c.toArray();
        boolean result = false;
        for (int i = 0; i < vals.length; ++i) {
            result |= this.add(vals[i]);
        }
        return result;
    }

    public boolean addAll(int index, Collection c) {
        if (c == null || c.size() == 0) {
            return false;
        }
        Object[] vals = c.toArray();
        int i = vals.length;
        while (--i >= 0) {
            this.add(index, vals[i]);
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        return this.records.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.records.retainAll(c);
    }

    public void clear() {
        this.records.clear();
        if (this.stockSearchResultMap != null) {
            this.stockSearchResultMap.clear();
        }
    }

    public RecordList cloneSchema() {
        RecordList clone = null;
        try {
            clone = (RecordList)super.clone();
            clone.records = Collections.synchronizedList(new ArrayList());
            if (this.stockSearchConditionMap != null && this.stockSearchConditionMap.size() != 0) {
                clone.stockSearchConditionMap = new HashMap();
                clone.stockSearchConditionMap.putAll(this.stockSearchConditionMap);
            }
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return clone;
    }

    public RecordList cloneRecordList() {
        RecordList recList = this.cloneSchema();
        if (this.size() == 0) {
            return recList;
        }
        for (int i = 0; i < this.records.size(); ++i) {
            Record rec = ((Record)this.records.get(i)).cloneRecord();
            recList.addRecord(rec);
        }
        return recList;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.cloneRecordList();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.schema != null) {
            this.recordSchema = RecordSchema.getInstance(this.schema);
        }
    }

    protected class RecordComparator
    implements Comparator {
        private String[] propNames;
        private boolean[] isAsc;

        public RecordComparator(String[] propNames) {
            this(propNames, null);
        }

        public RecordComparator(String[] propNames, boolean[] isAsc) {
            if (propNames == null || propNames.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            if (isAsc != null && propNames.length != isAsc.length) {
                throw new IllegalArgumentException("Length of property index array and sort flag array is unmatch.");
            }
            this.propNames = propNames;
            this.isAsc = isAsc;
        }

        public RecordComparator(int[] propIndexes) {
            this(propIndexes, null);
        }

        public RecordComparator(int[] propIndexes, boolean[] isAsc) {
            if (RecordList.this.recordSchema == null) {
                throw new IllegalArgumentException("Schema not initalize.");
            }
            if (propIndexes == null || propIndexes.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            if (isAsc != null && propIndexes.length != isAsc.length) {
                throw new IllegalArgumentException("Length of column name array and sort flag array is unmatch.");
            }
            this.propNames = new String[propIndexes.length];
            for (int i = 0; i < propIndexes.length; ++i) {
                this.propNames[i] = RecordList.this.recordSchema.getPropertyName(propIndexes[i]);
                if (this.propNames != null) continue;
                throw new IllegalArgumentException("Property not found : " + propIndexes[i]);
            }
            if (this.propNames == null || this.propNames.length == 0) {
                throw new IllegalArgumentException("Property name array is empty.");
            }
            this.isAsc = isAsc;
        }

        public int compare(Object o1, Object o2) {
            Record rd1 = (Record)o1;
            Record rd2 = (Record)o2;
            if (rd1 == null && rd2 == null) {
                return 0;
            }
            if (rd1 != null && rd2 == null) {
                return 1;
            }
            if (rd1 == null && rd2 != null) {
                return -1;
            }
            for (int i = 0; i < this.propNames.length; ++i) {
                Object val1 = rd1.getProperty(this.propNames[i]);
                Object val2 = rd2.getProperty(this.propNames[i]);
                if (val1 != null && val2 == null) {
                    return this.isAsc == null || this.isAsc[i] ? 1 : -1;
                }
                if (val1 == null && val2 != null) {
                    return this.isAsc == null || this.isAsc[i] ? -1 : 1;
                }
                if (val1 == null || val2 == null) continue;
                int comp = 0;
                comp = val1 instanceof Comparable ? ((Comparable)val1).compareTo(val2) : val1.hashCode() - val2.hashCode();
                if (comp == 0) continue;
                return this.isAsc == null || this.isAsc[i] ? comp : -1 * comp;
            }
            return 0;
        }
    }
}

