/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.beans.dataset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ossc.nimbus.beans.dataset.PropertySchema;
import jp.ossc.nimbus.beans.dataset.PropertySchemaDefineException;
import jp.ossc.nimbus.core.NimbusClassLoader;
import jp.ossc.nimbus.util.CsvArrayList;

public class RecordSchema {
    public static final String PROPERTY_SCHEMA_ALIAS_NAME_LIST = "LIST";
    private static final String PROP_SCHEMA_CLASS_DELIMETER = ":";
    protected static final Map recordSchemaManager = Collections.synchronizedMap(new HashMap());
    protected static final Map propertySchemaManager = Collections.synchronizedMap(new HashMap());
    protected Map propertySchemaMap = new LinkedHashMap();
    protected List propertyNames = new ArrayList();
    protected String schema;
    static /* synthetic */ Class class$jp$ossc$nimbus$beans$dataset$DefaultPropertySchema;
    static /* synthetic */ Class class$jp$ossc$nimbus$beans$dataset$RecordListPropertySchema;

    public static RecordSchema getInstance(String schema) throws PropertySchemaDefineException {
        RecordSchema recordSchema = (RecordSchema)recordSchemaManager.get(schema);
        if (recordSchema == null) {
            recordSchema = new RecordSchema();
            recordSchema.setSchema(schema);
            recordSchemaManager.put(schema, recordSchema);
        }
        return recordSchema;
    }

    public void setSchema(String schema) throws PropertySchemaDefineException {
        this.propertySchemaMap.clear();
        this.propertyNames.clear();
        CsvArrayList csv = new CsvArrayList();
        csv.splitCL(schema);
        Iterator itr = csv.iterator();
        while (itr.hasNext()) {
            String propertySchemaStr = (String)itr.next();
            if (propertySchemaStr == null || propertySchemaStr.length() == 0) continue;
            Class<?> propertySchemaClass = class$jp$ossc$nimbus$beans$dataset$DefaultPropertySchema == null ? RecordSchema.class$("jp.ossc.nimbus.beans.dataset.DefaultPropertySchema") : class$jp$ossc$nimbus$beans$dataset$DefaultPropertySchema;
            int index = propertySchemaStr.indexOf(PROP_SCHEMA_CLASS_DELIMETER);
            if (index == -1 || index == propertySchemaStr.length() - 1) {
                throw new PropertySchemaDefineException(propertySchemaStr, "The class name of PropertySchema is not specified.");
            }
            if (index != 0) {
                String propertySchemaClassName = propertySchemaStr.substring(0, index);
                if (PROPERTY_SCHEMA_ALIAS_NAME_LIST.equals(propertySchemaClassName)) {
                    propertySchemaClass = class$jp$ossc$nimbus$beans$dataset$RecordListPropertySchema == null ? RecordSchema.class$("jp.ossc.nimbus.beans.dataset.RecordListPropertySchema") : class$jp$ossc$nimbus$beans$dataset$RecordListPropertySchema;
                } else {
                    try {
                        propertySchemaClass = Class.forName(propertySchemaClassName, true, NimbusClassLoader.getInstance());
                    }
                    catch (ClassNotFoundException e) {
                        throw new PropertySchemaDefineException(propertySchemaStr, "The class name of PropertySchema is illegal.", e);
                    }
                }
            }
            propertySchemaStr = propertySchemaStr.substring(index + 1);
            String propertySchemaKey = propertySchemaClass.getName() + propertySchemaStr;
            PropertySchema propertySchema = (PropertySchema)propertySchemaManager.get(propertySchemaKey);
            if (propertySchema == null) {
                try {
                    propertySchema = (PropertySchema)propertySchemaClass.newInstance();
                }
                catch (InstantiationException e) {
                    throw new PropertySchemaDefineException(propertySchemaStr, e);
                }
                catch (IllegalAccessException e) {
                    throw new PropertySchemaDefineException(propertySchemaStr, e);
                }
                propertySchema.setSchema(propertySchemaStr);
                propertySchemaManager.put(propertySchemaKey, propertySchema);
            }
            this.propertySchemaMap.put(propertySchema.getName(), propertySchema);
            this.propertyNames.add(propertySchema.getName());
        }
        this.schema = schema;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getPropertyName(int index) {
        if (index < 0 || index >= this.propertyNames.size()) {
            return null;
        }
        return (String)this.propertyNames.get(index);
    }

    public int getPropertyIndex(String name) {
        return this.propertyNames.indexOf(name);
    }

    public PropertySchema getPropertySchema(int index) {
        if (index < 0 || index >= this.propertyNames.size()) {
            return null;
        }
        return (PropertySchema)this.propertySchemaMap.get(this.propertyNames.get(index));
    }

    public PropertySchema getPropertySchema(String name) {
        if (name == null) {
            return null;
        }
        return (PropertySchema)this.propertySchemaMap.get(name);
    }

    public PropertySchema[] getPropertySchemata() {
        return this.propertySchemaMap.values().toArray(new PropertySchema[this.propertySchemaMap.size()]);
    }

    public int getPropertySize() {
        return this.propertyNames.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        if (this.propertySchemaMap != null) {
            Iterator schemata = this.propertySchemaMap.values().iterator();
            while (schemata.hasNext()) {
                buf.append(schemata.next());
                if (!schemata.hasNext()) continue;
                buf.append(';');
            }
        }
        buf.append('}');
        return buf.toString();
    }
}

