/*
 * Decompiled with CFR 0.152.
 */
package jp.ossc.nimbus.io;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexFileFilter
implements FilenameFilter,
Serializable {
    private static final long serialVersionUID = -7076739508599572780L;
    private Pattern pattern;

    public RegexFileFilter() {
        this(null);
    }

    public RegexFileFilter(String regex) {
        this(regex, 0);
    }

    public RegexFileFilter(String regex, int flags) {
        this.setPattern(regex, flags);
    }

    public void setPattern(String regex) {
        this.pattern = regex == null ? null : Pattern.compile(regex);
    }

    public void setPattern(String regex, int flags) {
        this.pattern = regex == null ? null : Pattern.compile(regex, flags);
    }

    public boolean accept(File dir, String fileName) {
        if (this.pattern == null) {
            return false;
        }
        Matcher matcher = this.pattern.matcher(fileName);
        return matcher.matches();
    }
}

